package com.craftycorvid.improvedmaps.mixin;

import org.apache.commons.lang3.math.Fraction;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import com.craftycorvid.improvedmaps.internal.ICustomBundleContentBuilder;
import net.fabricmc.fabric.mixin.transfer.BundleContentsComponentAccessor;
import net.minecraft.class_1799;
import net.minecraft.class_3532;
import net.minecraft.class_9276;

// Implementation Based on
// https://github.com/FaeWulf/Diversity/blob/sub-mod-1.21.5/common-better-bundle/src/main/java/xyz/faewulf/diversity_better_bundle/mixin/item/buildingBundle/BuilderMixin.java
@Mixin(class_9276.class_9277.class)
public abstract class BundleContentsBuilderMixin implements ICustomBundleContentBuilder {
    @Shadow
    private Fraction occupancy;

    @Unique
    private int maxSize = 64;

    @Inject(method = "getMaxAllowed", at = @At("RETURN"), cancellable = true)
    private void getMaxAllowedInject(class_1799 stack, CallbackInfoReturnable<Integer> cir) {
        int itemValue = class_3532
                .method_59515(BundleContentsComponentAccessor.getOccupancy(stack), 64);

        int usedSpace = class_3532.method_59515(this.occupancy, 64);
        int freeSpace = maxSize - usedSpace;

        cir.setReturnValue(Math.max(freeSpace / itemValue, 0));
    }

    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }

}
