package com.craftycorvid.improvedmaps.recipe;

import java.util.List;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_314;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9694;
import com.craftycorvid.improvedmaps.ImprovedMaps;
import com.craftycorvid.improvedmaps.ImprovedMapsUtils;
import com.craftycorvid.improvedmaps.item.ImprovedMapsItems;
import eu.pb4.polymer.core.api.utils.PolymerObject;

public class AtlasCopyRecipe extends class_1852 {
    public AtlasCopyRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(class_9694 inventory, class_1937 world) {
        List<class_1799> itemStacks = inventory.method_59989();
        Boolean hasAtlas = false;
        Boolean hasBook = false;
        for (class_1799 stack : itemStacks) {
            if (stack.method_31574(ImprovedMapsItems.ATLAS)) {
                hasAtlas = true;
            } else if (stack.method_31574(class_1802.field_8529)) {
                hasBook = true;
            }
        }
        if (itemStacks.size() == 2 && hasAtlas && hasBook) {
            return true;
        }
        return false;
    }

    @Override
    public class_1799 craft(class_9694 inventory, class_7225.class_7874 lookup) {
        List<class_1799> atlases = inventory.method_59989().stream()
                .filter(stack -> stack.method_31574(ImprovedMapsItems.ATLAS)).toList();

        class_1799 originalAtlas = atlases.getFirst();
        return ImprovedMapsUtils.copyAtlas(originalAtlas);

    }

    @Override
    public class_1866<AtlasCopyRecipe> method_8119() {
        return ImprovedMaps.ATLAS_COPY_RECIPE_SERIALIZER;
    }

    @Override
    public class_10355 method_64668() {
        return class_314.field_1813;
    }

    public static class Serializer extends class_1866<AtlasCopyRecipe>
            implements PolymerObject {

        public Serializer(
                class_1852.class_1866.class_7711<AtlasCopyRecipe> factory) {
            super(factory);
        }
    }
}
