package com.craftycorvid.improvedmaps.recipe;

import java.util.List;
import net.minecraft.class_10355;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1852;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_314;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.class_9694;
import com.craftycorvid.improvedmaps.ImprovedMaps;
import com.craftycorvid.improvedmaps.ImprovedMapsComponentTypes;
import com.craftycorvid.improvedmaps.internal.ICustomBundleContentBuilder;
import com.craftycorvid.improvedmaps.item.ImprovedMapsItems;
import eu.pb4.polymer.core.api.utils.PolymerObject;

public class AtlasRecipe extends class_1852 {
    public AtlasRecipe(class_7710 category) {
        super(category);
    }

    @Override
    public boolean matches(class_9694 inventory, class_1937 world) {
        List<class_1799> itemStacks = inventory.method_59989();
        class_1799 filledMap = class_1799.field_8037;
        Boolean hasBook = false;
        for (class_1799 stack : itemStacks) {
            if (stack.method_31574(class_1802.field_8204)) {
                filledMap = stack;
            } else if (stack.method_31574(class_1802.field_8529)) {
                hasBook = true;
            }
        }
        if (itemStacks.size() == 2 && hasBook && !filledMap.method_7960()) {
            class_22 state = class_1806.method_8001(filledMap, world);
            return state != null;
        }
        return false;
    }

    @Override
    public class_1799 craft(class_9694 inventory, class_7225.class_7874 lookup) {
        class_1799 atlas = new class_1799(ImprovedMapsItems.ATLAS);
        class_1799 map = inventory.method_59989().stream().filter(stack -> stack.method_31574(class_1802.field_8204))
                .findFirst().orElse(null);

        class_9276.class_9277 builder =
                new class_9276.class_9277(class_9276.field_49289);
        ((ICustomBundleContentBuilder) builder).setMaxSize(512);
        builder.method_57432(map);
        map.method_7933(1);
        atlas.method_57379(class_9334.field_49650, builder.method_57435());
        atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, 0);

        return atlas;
    }

    @Override
    public class_1866<AtlasRecipe> method_8119() {
        return ImprovedMaps.ATLAS_RECIPE_SERIALIZER;
    }

    @Override
    public class_10355 method_64668() {
        return class_314.field_1813;
    }

    public static class Serializer extends class_1866<AtlasRecipe>
            implements PolymerObject {

        public Serializer(
                class_1852.class_1866.class_7711<AtlasRecipe> factory) {
            super(factory);
        }
    }
}
