/*
 * Decompiled with CFR 0.152.
 */
package com.craftycorvid.improvedmaps;

import com.craftycorvid.improvedmaps.ImprovedMaps;
import com.craftycorvid.improvedmaps.ImprovedMapsComponentTypes;
import com.craftycorvid.improvedmaps.item.ImprovedMapsItems;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Semaphore;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_9209;
import net.minecraft.class_9276;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;

public class ImprovedMapsLifecycleEvents {
    private static final Semaphore mutex = new Semaphore(1);

    public static void ImprovedMapsServerTick(MinecraftServer server) {
        for (class_3222 player : server.method_3760().method_14571()) {
            class_1799 offHand;
            if (player.method_31481() || player.method_14208() || player.method_14239()) continue;
            class_1799 mainHand = player.method_5998(class_1268.field_5808);
            if (mainHand.method_31574(ImprovedMapsItems.ATLAS)) {
                ImprovedMapsLifecycleEvents.AtlasPlayerHandTick(player, mainHand, class_1304.field_6173);
            }
            if (!(offHand = player.method_5998(class_1268.field_5810)).method_31574(ImprovedMapsItems.ATLAS)) continue;
            ImprovedMapsLifecycleEvents.AtlasPlayerHandTick(player, offHand, class_1304.field_6171);
        }
    }

    public static void AtlasPlayerHandTick(class_3222 player, class_1799 atlas, class_1304 slot) {
        class_1799 newMap;
        boolean isPlayerOutsideAllMapRegions;
        class_1937 world = player.method_37908();
        List<class_1799> currentDimMapItemStacks = ImprovedMapsLifecycleEvents.getCurrentDimMapsFromAtlas(world, atlas);
        class_1799 mapStack = ImprovedMapsLifecycleEvents.getActiveAtlasMap(currentDimMapItemStacks, player);
        if (mapStack == null) {
            return;
        }
        class_22 activeState = class_1806.method_8001((class_1799)mapStack, (class_1937)world);
        byte scale = activeState.field_119;
        int scaleWidth = (1 << scale) * 128;
        boolean bl = isPlayerOutsideAllMapRegions = ImprovedMapsLifecycleEvents.distanceBetweenMapStateAndPlayer(activeState, (class_1657)player) > (double)scaleWidth;
        if (isPlayerOutsideAllMapRegions && (newMap = ImprovedMapsLifecycleEvents.maybeCreateNewMapEntry(player, atlas, scale, class_3532.method_15357((double)player.method_23317()), class_3532.method_15357((double)player.method_23321()))) != null) {
            mapStack = newMap;
        }
        if (mapStack.method_31574(class_1802.field_8204)) {
            atlas.method_57379(class_9334.field_49646, (Object)((class_9209)mapStack.method_58694(class_9334.field_49646)));
            mapStack.method_7917(world, (class_1297)player, slot);
        }
    }

    public static List<class_1799> getAllMapsFromAtlas(class_1937 world, class_1799 atlas) {
        class_9276 bundleContents = (class_9276)atlas.method_58694(class_9334.field_49650);
        ArrayList<class_1799> mapStacks = new ArrayList<class_1799>();
        bundleContents.method_57421().forEach(map -> {
            if (!map.method_7960() && map.method_31574(class_1802.field_8204)) {
                mapStacks.add((class_1799)map);
            }
        });
        return mapStacks;
    }

    public static List<class_1799> getCurrentDimMapsFromAtlas(class_1937 world, class_1799 atlas) {
        return ImprovedMapsLifecycleEvents.getAllMapsFromAtlas(world, atlas).stream().filter(map -> {
            class_22 mapState = class_1806.method_8001((class_1799)map, (class_1937)world);
            return mapState != null ? mapState.field_118.method_29177().method_12833(world.method_27983().method_29177()) == 0 : false;
        }).toList();
    }

    public static class_1799 getActiveAtlasMap(List<class_1799> currentDimMapItemStacks, class_3222 player) {
        class_1799 minDistStack = null;
        for (class_1799 stack : currentDimMapItemStacks) {
            if (minDistStack == null) {
                minDistStack = stack;
                continue;
            }
            double previous = ImprovedMapsLifecycleEvents.distanceBetweenMapStateAndPlayer(class_1806.method_8001((class_1799)minDistStack, (class_1937)player.method_37908()), (class_1657)player);
            double current = ImprovedMapsLifecycleEvents.distanceBetweenMapStateAndPlayer(class_1806.method_8001((class_1799)stack, (class_1937)player.method_37908()), (class_1657)player);
            if (!(current < previous)) continue;
            minDistStack = stack;
        }
        return minDistStack;
    }

    public static double distanceBetweenMapStateAndPlayer(class_22 mapState, class_1657 player) {
        return Math.hypot(Math.abs((double)mapState.field_116 - player.method_23317()), Math.abs((double)mapState.field_115 - player.method_23321()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static class_1799 maybeCreateNewMapEntry(class_3222 player, class_1799 atlas, int scale, int destX, int destZ) {
        class_9276 bundleContents = (class_9276)atlas.method_58694(class_9334.field_49650);
        class_9276.class_9277 builder = new class_9276.class_9277(bundleContents);
        int emptyCount = (Integer)atlas.method_58694(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT);
        if (mutex.availablePermits() > 0 && (emptyCount > 0 || player.method_68878())) {
            try {
                mutex.acquire();
                class_1799 newMap = class_1806.method_8005((class_3218)((class_3218)player.method_37908()), (int)destX, (int)destZ, (byte)((byte)scale), (boolean)true, (boolean)false);
                builder.method_57432(newMap);
                atlas.method_57379(class_9334.field_49650, (Object)builder.method_57435());
                atlas.method_57379(ImprovedMapsComponentTypes.ATLAS_EMPTY_MAP_COUNT, (Object)(emptyCount - 1));
                class_1799 class_17992 = newMap;
                return class_17992;
            }
            catch (InterruptedException e) {
                ImprovedMaps.LOGGER.warn(e.getMessage());
            }
            finally {
                mutex.release();
            }
        }
        return null;
    }
}

