/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.tiv.network;

import net.mcreator.tiv.TornadoInterceptMod;
import net.mcreator.tiv.procedures.TurnOffHeadlightsOnKeyPressedProcedure;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record TurnOffHeadlightsMessage(int eventType, int pressedms) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<TurnOffHeadlightsMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tornado_intercept", (String)"key_turn_off_headlights"));
    public static final StreamCodec<RegistryFriendlyByteBuf, TurnOffHeadlightsMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.eventType);
        buffer.writeInt(message.pressedms);
    }, buffer -> new TurnOffHeadlightsMessage(buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<TurnOffHeadlightsMessage> type() {
        return TYPE;
    }

    public static void handleData(TurnOffHeadlightsMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> TurnOffHeadlightsMessage.pressAction(context.player(), message.eventType, message.pressedms)).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void pressAction(Player entity, int type, int pressedms) {
        Level world = entity.level();
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        if (!world.hasChunkAt(entity.blockPosition())) {
            return;
        }
        if (type == 0) {
            TurnOffHeadlightsOnKeyPressedProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TornadoInterceptMod.addNetworkMessage(TYPE, STREAM_CODEC, TurnOffHeadlightsMessage::handleData);
    }
}

