/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.api.stats;

import com.diamssword.characters.api.stats.StatsRolePalier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;

public abstract class StatsRole {
    public final String name;
    public final String id;
    public final int[] stages;
    protected Map<Integer, StatsRolePalier> map = new TreeMap<Integer, StatsRolePalier>();
    protected Map<class_1320, Function<Integer, class_1322>> globalModifiers = new HashMap<class_1320, Function<Integer, class_1322>>();

    public StatsRole(String id, JsonObject data) {
        this.id = id;
        int[] p = new int[]{};
        if (data.has("stages")) {
            p = data.get("stages").getAsJsonArray().asList().stream().map(JsonElement::getAsInt).mapToInt(Integer::intValue).toArray();
        }
        this.name = data.get("name").getAsString();
        this.stages = p;
    }

    public abstract void init();

    public int create(int level, Consumer<StatsRolePalier> init) {
        StatsRolePalier c = new StatsRolePalier(this, level);
        this.map.put(level, c);
        init.accept(c);
        return level;
    }

    public StatsRolePalier getPalierInfos(int palier) {
        return this.map.get(palier);
    }

    public int getPalierForLevel(int level) {
        int d = 0;
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] > level) {
                return d;
            }
            d = i + 1;
        }
        return d;
    }

    public void addGlobalModifier(class_1320 attr, Function<Integer, class_1322> modifier) {
        this.globalModifiers.put(attr, modifier);
    }

    public Map<class_1320, Function<Integer, class_1322>> getGlobalModifiers() {
        return this.globalModifiers;
    }

    public void onLevelChange(class_1657 pl, int level) {
        this.changeModifiers(pl, level);
    }

    private void changeModifiers(class_1657 pl, int level) {
        for (Map.Entry<Integer, StatsRolePalier> entry : this.map.entrySet()) {
            entry.getValue().clearModifier(pl);
        }
        for (Map.Entry<Integer, Object> entry : this.globalModifiers.entrySet()) {
            class_1324 max = pl.method_5996((class_1320)entry.getKey());
            class_1322 r = (class_1322)((Function)entry.getValue()).apply(level);
            max.method_27304(r.method_6189());
            max.method_26837(r);
        }
        for (int last = this.getPalierForLevel(level); last > 0; --last) {
            StatsRolePalier statsRolePalier = this.map.get(last);
            if (statsRolePalier == null) {
                continue;
            }
            statsRolePalier.changeModifiers(pl);
            break;
        }
    }
}

