/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client;

import com.diamssword.characters.api.PlayerPresence;
import com.diamssword.characters.client.B64MinecraftProfileTexture;
import com.diamssword.characters.client.B64PlayerSkinTexture;
import com.diamssword.characters.client.ClientComesticsPacket;
import com.diamssword.characters.mixins.PlayerSkinProviderAccessor;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.SkinServerCache;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1044;
import net.minecraft.class_1047;
import net.minecraft.class_1068;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;

public class SkinsLoader {
    public static final SkinServerCache clientSkinCache = new SkinServerCache();
    private final Set<UUID> needReload = new HashSet<UUID>();
    private final Set<UUID> requested = new HashSet<UUID>();
    private final Set<UUID> requestedOfflineHead = new HashSet<UUID>();
    private final Map<UUID, Set<Consumer<class_2960>>> pendingOfflineheadRequest = new HashMap<UUID, Set<Consumer<class_2960>>>();
    private final Map<UUID, class_2960> offlineHeadCache = new HashMap<UUID, class_2960>();
    private final File cacheDir = ((PlayerSkinProviderAccessor)class_310.method_1551().method_1582()).getCacheDir();
    public static SkinsLoader instance = new SkinsLoader();

    public boolean doesNeedReload(UUID playerid) {
        return this.needReload.contains(playerid);
    }

    public boolean markReload(UUID playerid, boolean needed) {
        if (needed) {
            this.requested.remove(playerid);
            this.offlineHeadCache.remove(playerid);
            this.needReload.add(playerid);
        } else if (this.needReload.contains(playerid)) {
            this.needReload.remove(playerid);
            return true;
        }
        return false;
    }

    public static void getHeadTexture(UUID playerID, Consumer<class_2960> callback) {
        class_640 profile = class_310.method_1551().method_1562().method_2871(playerID);
        if (profile != null) {
            instance.loadSkin(profile.method_2966().getId(), true, (a, b, c) -> callback.accept(b));
            return;
        }
        instance.getOfflineHead(playerID, callback);
    }

    public void loadSkinHeadOffline(UUID player, String base64) {
        Runnable runnable = () -> class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(() -> {
            B64MinecraftProfileTexture txt = new B64MinecraftProfileTexture(base64, new HashMap<String, String>());
            String string = Hashing.sha1().hashUnencodedChars((CharSequence)txt.getHash()).toString();
            class_2960 identifier = new class_2960("heads/" + string);
            B64PlayerSkinTexture playerSkinTexture = new B64PlayerSkinTexture(null, base64, class_1068.method_4649(), () -> {
                this.offlineHeadCache.put(player, identifier);
                Set<Consumer<class_2960>> k = this.pendingOfflineheadRequest.get(player);
                if (k != null) {
                    k.forEach(x -> x.accept(identifier));
                    this.pendingOfflineheadRequest.remove(player);
                }
            });
            class_310.method_1551().method_1531().method_4616(identifier, (class_1044)playerSkinTexture);
        }));
        class_156.method_18349().execute(runnable);
    }

    public void loadSkin(UUID userid, boolean isHead, SkinTextureAvailableCallback callback) {
        boolean force = this.markReload(userid, false);
        Runnable runnable = () -> class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(() -> {
            Optional<SkinServerCache.PlayerInfos> skin = clientSkinCache.getSkin(userid);
            if (skin.isPresent()) {
                this.requested.remove(userid);
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("slim", skin.get().slim() ? "true" : "false");
                this.loadSkin(new B64MinecraftProfileTexture(isHead ? skin.get().head() : skin.get().skin(), map1), callback, force, isHead ? "heads" : "skins");
            } else if (!this.requested.contains(userid)) {
                Channels.MAIN.clientHandle().send(new SkinServerCache.RequestPlayerInfos(userid));
                this.requested.add(userid);
            }
        }));
        class_156.method_18349().execute(runnable);
    }

    private void getOfflineHead(UUID userid, Consumer<class_2960> callback) {
        Runnable runnable = () -> class_310.method_1551().execute(() -> RenderSystem.recordRenderCall(() -> {
            class_2960 skin = this.offlineHeadCache.get(userid);
            if (skin != null) {
                this.requestedOfflineHead.remove(userid);
                callback.accept(this.offlineHeadCache.get(userid));
            } else if (!this.requestedOfflineHead.contains(userid)) {
                Channels.MAIN.clientHandle().send(new SkinServerCache.RequestPlayerPresence(userid));
                if (!this.pendingOfflineheadRequest.containsKey(userid)) {
                    this.pendingOfflineheadRequest.put(userid, new HashSet());
                }
                this.pendingOfflineheadRequest.get(userid).add(callback);
                this.requestedOfflineHead.add(userid);
            }
        }));
        class_156.method_18349().execute(runnable);
    }

    public void loadSkin(GameProfile profile, SkinTextureAvailableCallback callback) {
        this.loadSkin(profile.getId(), false, callback);
    }

    private class_2960 loadSkin(B64MinecraftProfileTexture profileTexture, @Nullable SkinTextureAvailableCallback callback, boolean force, String type) {
        String string = Hashing.sha1().hashUnencodedChars((CharSequence)profileTexture.getHash()).toString();
        class_2960 identifier = new class_2960(type + "/" + string);
        class_1044 abstractTexture = class_310.method_1551().method_1531().method_34590(identifier, (class_1044)class_1047.method_4540());
        if (force || abstractTexture == class_1047.method_4540()) {
            File file = new File(this.cacheDir, string.length() > 2 ? string.substring(0, 2) : "xx");
            File file2 = new File(file, string);
            if (force && file2.exists()) {
                file2.delete();
            }
            B64PlayerSkinTexture playerSkinTexture = new B64PlayerSkinTexture(file2, profileTexture.getData(), class_1068.method_4649(), () -> {
                if (callback != null) {
                    callback.onSkinTextureAvailable(MinecraftProfileTexture.Type.SKIN, identifier, profileTexture);
                }
            });
            class_310.method_1551().method_1531().method_4616(identifier, (class_1044)playerSkinTexture);
        } else if (callback != null) {
            callback.onSkinTextureAvailable(MinecraftProfileTexture.Type.SKIN, identifier, profileTexture);
        }
        return identifier;
    }

    public static CompletableFuture<Map<UUID, PlayerPresence>> requestPlayerProfiles(String query) {
        Channels.MAIN.clientHandle().send(new SkinServerCache.RequestPlayersMatching(query));
        CompletableFuture<Map<UUID, PlayerPresence>> future = new CompletableFuture<Map<UUID, PlayerPresence>>();
        ClientComesticsPacket.PlayerProfilesRequestCallback = future::complete;
        return future;
    }

    @Environment(value=EnvType.CLIENT)
    public static interface SkinTextureAvailableCallback {
        public void onSkinTextureAvailable(MinecraftProfileTexture.Type var1, class_2960 var2, B64MinecraftProfileTexture var3);
    }
}

