/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client.gui;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.client.gui.OutfitPopupGui;
import com.diamssword.characters.client.gui.components.BaseComponent;
import com.diamssword.characters.client.gui.components.CategoryButton;
import com.diamssword.characters.client.gui.components.ClothButtonComponent;
import com.diamssword.characters.client.gui.components.PlayerComponent;
import com.diamssword.characters.client.gui.components.ScrollableCloths;
import com.diamssword.characters.client.gui.components.Sizing;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.CosmeticsPackets;
import com.diamssword.characters.storage.ClothingLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_342;
import net.minecraft.class_3545;
import net.minecraft.class_357;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7919;

public class WardrobeGui
extends class_437 {
    private final List<BaseComponent> components = new ArrayList<BaseComponent>();
    private final List<class_3545<String, LayerDef[]>> layerBts = new ArrayList<class_3545<String, LayerDef[]>>();
    private class_3545<String, LayerDef[]> currentLayer;
    private Map<String, Cloth> oldCloths;
    private String lastSearch = "";
    private final boolean shouldShowOutifits;
    private final Function<class_1657, Map<String, Cloth>> equippedProvider;

    public WardrobeGui(String type) {
        super((class_2561)class_2561.method_43470((String)""));
        List<LayerDef> layers;
        if (type == null || type.equals("default")) {
            this.shouldShowOutifits = true;
            layers = ClothingLoader.instance.getClothLayers();
            this.layerBts.add((class_3545<String, LayerDef[]>)new class_3545((Object)"all", (Object)layers.toArray(new LayerDef[0])));
            this.layerBts.add((class_3545<String, LayerDef[]>)new class_3545((Object)"current", (Object)layers.toArray(new LayerDef[0])));
            this.equippedProvider = p -> ComponentManager.getPlayerDatas(p).getAppearence().getEquippedCloths();
        } else {
            this.shouldShowOutifits = false;
            layers = ClothingLoader.instance.getLayers().values().stream().filter(v -> type.equals(v.getSpecialEditor())).toList();
            this.equippedProvider = p -> ComponentManager.getPlayerDatas(p).getAppearence().getEquippedLayers();
        }
        for (LayerDef l : layers) {
            this.layerBts.add((class_3545<String, LayerDef[]>)new class_3545((Object)l.getId(), (Object)new LayerDef[]{l}));
        }
        this.currentLayer = this.layerBts.get(0);
    }

    public <T extends BaseComponent> T addComponent(T comp) {
        this.components.add(comp);
        this.method_37060(comp);
        return comp;
    }

    protected void method_25426() {
        super.method_25426();
        this.components.clear();
        final PlayerComponent playerComp = this.addComponent(new PlayerComponent(Sizing.fill(40), Sizing.content(0))).scaleToFit(true).lookAtCursor(true);
        int rightX = (int)((float)this.field_22789 * 0.55f);
        int rightW = (int)((float)this.field_22789 * 0.4f);
        final ScrollableCloths scroll = (ScrollableCloths)this.method_37063((class_364)new ScrollableCloths(rightX, (int)((float)this.field_22790 * 0.2f), rightW, (int)((float)this.field_22790 * 0.7f)));
        class_342 search = new class_342(this.field_22787.field_1772, rightX, (int)((float)this.field_22790 * 0.2f) - 20, rightW, 18, (class_2561)class_2561.method_43471((String)"character_sheet.wardrobe.search"));
        class_357 slider = new class_357(0, 0, 0, 20, (class_2561)class_2561.method_43470((String)"0\u00b0"), 0.5){

            protected void method_25346() {
                int v = (int)(-180.0 + this.field_22753 * 360.0);
                this.method_25355((class_2561)class_2561.method_43470((String)(v + "\u00b0")));
            }

            protected void method_25344() {
                playerComp.rotation((int)(-180.0 + this.field_22753 * 360.0));
            }
        };
        search.method_47404((class_2561)class_2561.method_43471((String)"character_sheet.wardrobe.search"));
        this.method_25429((class_364)slider);
        this.method_37060((class_4068)slider);
        this.method_25429((class_364)search);
        this.method_37060((class_4068)search);
        this.components.forEach(c -> c.mount(0, 0, this.field_22789, this.field_22790));
        playerComp.x = (int)((float)this.field_22789 * 0.15f);
        playerComp.y = this.field_22790 / 2 - playerComp.height / 2;
        slider.method_46421(playerComp.x + 20);
        slider.method_25358(playerComp.width - 40);
        slider.method_46419(playerComp.y + playerComp.height + 5);
        class_1657 player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas(player);
        dt.getAppearence().clonePlayerAppearance((class_1657)class_310.method_1551().field_1724);
        this.loadCloths(scroll, playerComp, "");
        search.method_1863(v -> this.loadCloths(scroll, playerComp, v.toLowerCase()));
        this.method_25395((class_364)search);
        if (this.shouldShowOutifits) {
            List<class_3545<String, Integer>> outfits = dt.getAppearence().getOutfits();
            int mid = (int)((float)this.field_22790 * 0.2f - 20.0f);
            for (int i = 1; i <= 7; ++i) {
                class_5250 v2 = class_2561.method_43469((String)"character_sheet.wardrobe.outfitbt", (Object[])new Object[]{i});
                int i1 = i - 1;
                if (i1 < outfits.size()) {
                    v2 = class_2561.method_43470((String)((String)outfits.get(i1).method_15442()));
                }
                class_4185 bt = new class_4185.class_7840((class_2561)v2.method_27661(), a -> {
                    if (class_437.method_25442()) {
                        this.createOutfitWindow(a, i1);
                    } else {
                        Channels.MAIN.clientHandle().send(new CosmeticsPackets.EquipOutfit(i1));
                        dt.getAppearence().equipOutfit(i1);
                        this.loadCloths(scroll, playerComp, this.lastSearch);
                    }
                }).method_46433(5, mid + 22 * (i - 1)).method_46437((int)((float)this.field_22789 * 0.2f), 20).method_46436(class_7919.method_47407((class_2561)v2.method_10852((class_2561)class_2561.method_43471((String)"character_sheet.wardrobe.outfitbt.tooltip").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})))).method_46431();
                this.method_37063((class_364)bt);
                this.method_25429((class_364)bt);
            }
        }
        final ArrayList<CategoryButton> bts = new ArrayList<CategoryButton>();
        for (int i = 0; i < this.layerBts.size(); ++i) {
            final class_3545<String, LayerDef[]> value = this.layerBts.get(i);
            CategoryButton bt = new CategoryButton((class_2561)class_2561.method_43473(), Characters.asRessource("textures/gui/icons/" + (String)value.method_15442() + ".png"), new class_4185.class_4241(){

                public void onPress(class_4185 button) {
                    for (CategoryButton d : bts) {
                        d.setActivated(false);
                    }
                    if (button instanceof CategoryButton) {
                        CategoryButton oc = (CategoryButton)button;
                        oc.setActivated(true);
                    }
                    WardrobeGui.this.currentLayer = value;
                    WardrobeGui.this.loadCloths(scroll, playerComp, WardrobeGui.this.lastSearch);
                }
            });
            bt.method_46421((int)((float)this.field_22789 * 0.45f + (float)(i % 2 == 0 ? 0 : 22)));
            bt.method_46419(50 + 22 * (i / 2));
            bt.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)("character_sheet.wardrobe.layerbt." + (String)value.method_15442()))));
            if (((String)value.method_15442()).equals("all")) {
                bt.setActivated(true);
            }
            this.method_25429((class_364)bt);
            this.method_37060((class_4068)bt);
            bts.add(bt);
        }
    }

    private void loadCloths(ScrollableCloths layout, PlayerComponent playerComp, String filter) {
        this.lastSearch = filter;
        class_1657 player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas(player);
        this.oldCloths = this.equippedProvider.apply(player);
        List<Cloth> equip = this.oldCloths.values().stream().filter(Objects::nonNull).toList();
        List<Cloth> list = ((String)this.currentLayer.method_15442()).equals("current") ? equip : ClothingLoader.instance.getAvailablesClothsCollectionForPlayer((class_1657)class_310.method_1551().field_1724, "all", (LayerDef[])this.currentLayer.method_15441());
        if (!filter.isEmpty()) {
            list = list.stream().filter(v -> v.name().toLowerCase().contains(filter) || !v.collection().equals("default") && v.collection().toLowerCase().contains(filter)).toList();
        }
        layout.setCloths(list, c -> {
            ClothButtonComponent bt = new ClothButtonComponent((Cloth)c, a -> {
                a.method_25354(class_310.method_1551().method_1483());
                if (this.oldCloths.get(c.layer().id) == c) {
                    dt.getAppearence().setCloth(c.layer().id, null);
                    Channels.MAIN.clientHandle().send(new CosmeticsPackets.EquipCloth(new class_2960("null", "null"), c.layer().getId()));
                } else {
                    dt.getAppearence().setCloth(c.layer().id, (Cloth)c);
                    Channels.MAIN.clientHandle().send(new CosmeticsPackets.EquipCloth(c.id(), c.layer().toString()));
                }
                this.oldCloths = this.equippedProvider.apply(player);
                this.updateSelected(layout, this.oldCloths.values().stream().filter(Objects::nonNull).toList());
            }, layout);
            bt.onClothHovered(v -> {
                if (v != null) {
                    dt.getAppearence().setCloth((Cloth)v);
                } else {
                    this.oldCloths.forEach((a, v1) -> dt.getAppearence().setCloth((String)a, (Cloth)v1));
                }
            });
            return bt;
        });
        this.updateSelected(layout, equip);
    }

    private void updateSelected(ScrollableCloths layout, List<Cloth> equipped) {
        for (ClothButtonComponent cb : layout.children()) {
            cb.setSelected(equipped.stream().anyMatch(v -> v.id().equals((Object)cb.getCloth().id())));
        }
    }

    private void createOutfitWindow(class_4185 bt, int index) {
        class_310.method_1551().method_1507((class_437)new OutfitPopupGui(this, index, bt));
    }

    public boolean method_25421() {
        return false;
    }
}

