/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.network.owoNetwork;

import com.diamssword.characters.network.owoNetwork.ClientAccess;
import com.diamssword.characters.network.owoNetwork.NetworkException;
import com.diamssword.characters.network.owoNetwork.ReflectionUtils;
import com.diamssword.characters.network.owoNetwork.ServerAccess;
import com.diamssword.characters.network.owoNetwork.serialization.RecordSerializer;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OwoNetChannel {
    public static final Logger LOGGER = LogManager.getLogger((String)"owo_netork_impl");
    static final Map<class_2960, OwoNetChannel> REGISTERED_CHANNELS = new HashMap<class_2960, OwoNetChannel>();
    private final Map<Class<?>, IndexedSerializer<?>> serializersByClass = new HashMap();
    final Int2ObjectMap<IndexedSerializer<?>> serializersByIndex = new Int2ObjectOpenHashMap();
    private final List<ChannelHandler<Record, ClientAccess>> clientHandlers = new ArrayList<ChannelHandler<Record, ClientAccess>>();
    private final List<ChannelHandler<Record, ServerAccess>> serverHandlers = new ArrayList<ChannelHandler<Record, ServerAccess>>();
    private final Reference2IntMap<Class<?>> deferredClientSerializers = new Reference2IntOpenHashMap();
    final class_2960 packetId;
    private final String ownerClassName;
    private ClientHandle clientHandle = null;
    private ServerHandle serverHandle = null;

    public static OwoNetChannel create(class_2960 id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2));
    }

    public void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (class_2960)this.packetId, (buf, context) -> {
            int handlerIndex = buf.method_10816();
            Object message = ((IndexedSerializer)this.serializersByIndex.get((int)handlerIndex)).serializer.read(buf);
            context.getPlayer().method_5682().execute(() -> this.serverHandlers.get(handlerIndex).handle((Record)message, new ServerAccess((class_3222)context.getPlayer())));
        });
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (class_2960)this.packetId, this::handleClient);
        }
    }

    private OwoNetChannel(class_2960 id, String ownerClassName) {
        if (REGISTERED_CHANNELS.containsKey(id)) {
            throw new IllegalStateException("Channel with id '" + id + "' was already registered from class '" + OwoNetChannel.REGISTERED_CHANNELS.get((Object)id).ownerClassName + "'");
        }
        this.deferredClientSerializers.defaultReturnValue(-1);
        this.packetId = id;
        this.ownerClassName = ownerClassName;
        this.clientHandlers.add(null);
        this.serverHandlers.add(null);
        REGISTERED_CHANNELS.put(id, this);
    }

    private void handleClient(class_2540 buf, NetworkManager.PacketContext context) {
        int handlerIndex = buf.method_10816();
        Object message = ((IndexedSerializer)this.serializersByIndex.get((int)(-handlerIndex))).serializer.read(buf);
        class_310.method_1551().execute(() -> this.clientHandlers.get(handlerIndex).handle((Record)message, new ClientAccess(class_310.method_1551().method_1562())));
    }

    public <R extends Record> void registerClientbound(Class<R> messageClass, ChannelHandler<R, ClientAccess> handler) {
        int deferredIndex = this.deferredClientSerializers.removeInt(messageClass);
        if (deferredIndex != -1) {
            this.clientHandlers.set(deferredIndex, handler);
            return;
        }
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, Env.CLIENT);
        this.clientHandlers.add(handler);
    }

    public <R extends Record> void registerClientboundDeferred(Class<R> messageClass) {
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, Env.CLIENT);
        this.clientHandlers.add(null);
        this.deferredClientSerializers.put(messageClass, index);
    }

    public <R extends Record> void registerServerbound(Class<R> messageClass, ChannelHandler<R, ServerAccess> handler) {
        int index = this.serverHandlers.size();
        this.createSerializer(messageClass, index, Env.SERVER);
        this.serverHandlers.add(handler);
    }

    public ClientHandle clientHandle() {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new NetworkException("Cannot obtain client handle in environment type '" + Platform.getEnvironment() + "'");
        }
        if (this.clientHandle == null) {
            this.clientHandle = new ClientHandle();
        }
        return this.clientHandle;
    }

    public ServerHandle serverHandle(MinecraftServer server) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = server.method_3760().method_14571();
        return handle;
    }

    public ServerHandle serverHandle(Collection<class_3222> targets) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = targets;
        return handle;
    }

    public ServerHandle serverHandle(class_1657 player) {
        if (!(player instanceof class_3222)) {
            throw new NetworkException("'player' must be a 'ServerPlayerEntity'");
        }
        class_3222 serverPlayer = (class_3222)player;
        ServerHandle handle = this.getServerHandle();
        handle.targets = Collections.singleton(serverPlayer);
        return handle;
    }

    public ServerHandle serverHandle(class_2586 entity) {
        if (entity.method_10997().field_9236) {
            throw new NetworkException("Server handle cannot be obtained on the client");
        }
        return this.serverHandle(OwoNetChannel.tracking(entity));
    }

    public static Collection<class_3222> tracking(class_2586 blockEntity) {
        Objects.requireNonNull(blockEntity, "BlockEntity cannot be null");
        if (!blockEntity.method_11002() || blockEntity.method_10997().method_8608()) {
            throw new IllegalArgumentException("Only supported on server worlds!");
        }
        return OwoNetChannel.tracking((class_3218)blockEntity.method_10997(), blockEntity.method_11016());
    }

    public static Collection<class_3222> tracking(class_3218 world, class_2338 pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return OwoNetChannel.tracking(world, new class_1923(pos));
    }

    public static Collection<class_3222> tracking(class_3218 world, class_1923 pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.method_14178().field_17254.method_17210(pos, false);
    }

    public ServerHandle serverHandle(class_3218 world, class_2338 pos) {
        return this.serverHandle(OwoNetChannel.tracking(world, pos));
    }

    private ServerHandle getServerHandle() {
        if (this.serverHandle == null) {
            this.serverHandle = new ServerHandle();
        }
        return this.serverHandle;
    }

    private <R extends Record> void createSerializer(Class<R> messageClass, int handlerIndex, Env target) {
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer == null) {
            IndexedSerializer<R> indexedSerializer = IndexedSerializer.create(RecordSerializer.create(messageClass), handlerIndex, target);
            this.serializersByClass.put(messageClass, indexedSerializer);
            this.serializersByIndex.put(target == Env.CLIENT ? -handlerIndex : handlerIndex, indexedSerializer);
        } else if (serializer.handlerIndex(target) == -1) {
            serializer.setHandlerIndex(handlerIndex, target);
            this.serializersByIndex.put(target == Env.CLIENT ? -handlerIndex : handlerIndex, serializer);
        } else {
            throw new IllegalStateException("Message class '" + messageClass.getName() + "' is already registered for target environment " + target);
        }
    }

    private <R extends Record> class_2540 encode(R message, Env target) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        Class<?> messageClass = message.getClass();
        if (!this.serializersByClass.containsKey(messageClass)) {
            throw new NetworkException("Message class '" + messageClass + "' is not registered");
        }
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer.handlerIndex(target) == -1) {
            throw new NetworkException("Message class '" + messageClass + "' has not handler registered for target environment " + target);
        }
        buffer.method_10804(serializer.handlerIndex(target));
        serializer.serializer.write(buffer, message);
        return buffer;
    }

    private void verify() {
        if (Platform.getEnvironment() == Env.CLIENT && this.deferredClientSerializers.size() > 0) {
            throw new NetworkException("Some deferred client handlers for channel " + this.packetId + " haven't been registered: " + this.deferredClientSerializers.keySet().stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
    }

    public class ClientHandle {
        public <R extends Record> void send(R message) {
            NetworkManager.sendToServer((class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, Env.SERVER));
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                this.send(message);
            }
        }
    }

    public class ServerHandle {
        private Collection<class_3222> targets = Collections.emptySet();

        public <R extends Record> void send(R message) {
            NetworkManager.sendToPlayers(this.targets, (class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, Env.CLIENT));
            this.targets = null;
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                NetworkManager.sendToPlayers(this.targets, (class_2960)OwoNetChannel.this.packetId, (class_2540)OwoNetChannel.this.encode(message, Env.CLIENT));
            }
            this.targets = null;
        }
    }

    static final class IndexedSerializer<R extends Record> {
        private int clientHandlerIndex = -1;
        private int serverHandlerIndex = -1;
        final RecordSerializer<R> serializer;

        private IndexedSerializer(RecordSerializer<R> serializer) {
            this.serializer = serializer;
        }

        public static <R extends Record> IndexedSerializer<R> create(RecordSerializer<R> serializer, int index, Env target) {
            return new IndexedSerializer<R>(serializer).setHandlerIndex(index, target);
        }

        public IndexedSerializer<R> setHandlerIndex(int index, Env target) {
            switch (target) {
                case CLIENT: {
                    this.clientHandlerIndex = index;
                    break;
                }
                case SERVER: {
                    this.serverHandlerIndex = index;
                }
            }
            return this;
        }

        public int handlerIndex(Env target) {
            return switch (target) {
                default -> throw new IncompatibleClassChangeError();
                case Env.CLIENT -> this.clientHandlerIndex;
                case Env.SERVER -> this.serverHandlerIndex;
            };
        }
    }

    public static interface ChannelHandler<R extends Record, E extends EnvironmentAccess<?, ?, ?>> {
        public void handle(R var1, E var2);
    }

    public static interface EnvironmentAccess<P extends class_1657, R, N> {
        public P player();

        public R runtime();

        public N netHandler();
    }
}

