/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters;

import com.diamssword.characters.Events;
import com.diamssword.characters.InventorySaver;
import com.diamssword.characters.api.CharactersApi;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.client.ClientComesticsPacket;
import com.diamssword.characters.client.Entities;
import com.diamssword.characters.commands.ClothCommand;
import com.diamssword.characters.commands.PStatsCommand;
import com.diamssword.characters.commands.SkinCommand;
import com.diamssword.characters.commands.WardrobeCommand;
import com.diamssword.characters.config.Config;
import com.diamssword.characters.config.ConfigManager;
import com.diamssword.characters.implementations.CharactersApiImpl;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.storage.ClassesLoader;
import com.diamssword.characters.storage.ClothingLoader;
import com.diamssword.characters.storage.PlayerAppearance;
import com.diamssword.characters.storage.PlayerCharacters;
import com.diamssword.characters.storage.PlayerStats;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2960;
import net.minecraft.class_3264;
import net.minecraft.class_3302;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Characters {
    public static final String MOD_ID = "character_sheet";
    public static final Logger LOGGER = LogManager.getLogger((String)"character_sheet");
    public static Config config;

    public static void init() {
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)ClothingLoader.instance, (class_2960)ClothingLoader.instance.getId());
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)ClassesLoader.instance, (class_2960)ClassesLoader.instance.getId());
        ClassesLoader.initEvents();
        CharactersApi.instance = new CharactersApiImpl();
        PlayerCharacters.attachComponentToCharacters(CharactersApi.CHARACTER_ATTACHED_COMPONENT_APPEARANCE, p -> ComponentManager.getPlayerDatas((class_1657)p).getAppearence(), PlayerAppearance::serializer, PlayerAppearance::unserializer);
        PlayerCharacters.attachComponentToCharacters(CharactersApi.CHARACTER_ATTACHED_COMPONENT_INVENTORY, InventorySaver::new, InventorySaver::serializer, InventorySaver::unserializer);
        PlayerCharacters.attachComponentToCharacters(CharactersApi.CHARACTER_ATTACHED_COMPONENT_STATS, p -> ComponentManager.getPlayerDatas((class_1657)p).getStats(), PlayerStats::serializer, PlayerStats::unserializer);
        config = ConfigManager.loadConfig();
        Channels.init();
        Events.init();
        if (Platform.getEnvironment() == Env.CLIENT) {
            Characters.initClient();
        }
        Characters.registerCommand("character", SkinCommand::register);
        Characters.registerCommand("cloths", ClothCommand::register);
        Characters.registerCommand("playerskills", PStatsCommand::register);
        Characters.registerCommand("wardrobe", WardrobeCommand::register);
    }

    @Environment(value=EnvType.CLIENT)
    public static void initClient() {
        ClientComesticsPacket.init();
        Entities.init();
    }

    public static class_2960 asRessource(String name) {
        return new class_2960(MOD_ID, name);
    }

    public static void registerCommand(String name, Consumer<LiteralArgumentBuilder<class_2168>> builder) {
        LiteralArgumentBuilder l = class_2170.method_9247((String)name);
        builder.accept((LiteralArgumentBuilder<class_2168>)l);
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(l));
    }
}

