/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.jetbrains.annotations.Nullable;

public class B64MinecraftProfileTexture {
    private final String data;
    private final Map<String, String> metadata;

    public B64MinecraftProfileTexture(String data, Map<String, String> metadata) {
        this.data = data;
        this.metadata = metadata;
    }

    public String getData() {
        return this.data;
    }

    @Nullable
    public String getMetadata(String key) {
        if (this.metadata == null) {
            return null;
        }
        return this.metadata.get(key);
    }

    public String getHash() {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-256");
            byte[] hashBytes = digest.digest(this.data.getBytes(StandardCharsets.UTF_8));
            return B64MinecraftProfileTexture.bytesToHex(hashBytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("SHA-256 not supported", e);
        }
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder hexString = new StringBuilder(2 * bytes.length);
        for (byte b : bytes) {
            hexString.append(String.format("%02x", b));
        }
        return hexString.toString();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("base64", (Object)this.data).append("hash", (Object)this.getHash()).toString();
    }
}

