/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client.gui.components;

import java.util.Objects;
import java.util.function.Function;
import net.minecraft.class_3532;

public class Sizing {
    private static final Sizing CONTENT_SIZING = new Sizing(0, Method.CONTENT);
    public final Method method;
    public final int value;

    private Sizing(int value, Method method) {
        this.method = method;
        this.value = value;
    }

    public int inflate(int space, Function<Sizing, Integer> contentSizeFunction) {
        return switch (this.method) {
            default -> throw new IncompatibleClassChangeError();
            case Method.FIXED -> this.value;
            case Method.FILL -> Math.round((float)this.value / 100.0f * (float)space);
            case Method.CONTENT -> contentSizeFunction.apply(this) + this.value * 2;
        };
    }

    public static Sizing fixed(int value) {
        return new Sizing(value, Method.FIXED);
    }

    public static Sizing content() {
        return CONTENT_SIZING;
    }

    public static Sizing content(int padding) {
        return new Sizing(padding, Method.CONTENT);
    }

    public static Sizing fill(int percent) {
        return new Sizing(percent, Method.FILL);
    }

    public boolean isContent() {
        return this.method == Method.CONTENT;
    }

    public Sizing interpolate(Sizing next, float delta) {
        if (next.method != this.method) {
            return this;
        }
        return new Sizing(class_3532.method_48781((float)delta, (int)this.value, (int)next.value), this.method);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Sizing sizing = (Sizing)o;
        return this.value == sizing.value && this.method == sizing.method;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.method, this.value});
    }

    public static enum Method {
        FIXED,
        CONTENT,
        FILL;

    }
}

