/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.commands;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.storage.ClothingLoader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class ClothCommand {
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> class_2172.method_9265(ClothingLoader.instance.getClothIds(), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER_LAYER = (context, builder) -> class_2172.method_9265(ClothingLoader.instance.getLayers().keySet(), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)builder.requires(ctx -> ctx.method_9259(2));
        for (String str : new String[]{"unlock", "lock", "set"}) {
            root.then(class_2170.method_9247((String)str).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(SUGGESTION_PROVIDER).executes(ctx -> ClothCommand.Exec((CommandContext<class_2168>)ctx, str)))));
        }
        root.then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9308()).then(class_2170.method_9244((String)"layer", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER_LAYER).executes(ClothCommand::ExecRemove))));
    }

    private static int ExecRemove(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        Iterator iterator;
        Collection players = class_2186.method_9312(ctx, (String)"player");
        String layerID = StringArgumentType.getString(ctx, (String)"layer");
        Optional<LayerDef> layer = ClothingLoader.instance.getLayer(layerID);
        if (layer.isPresent() && (iterator = players.iterator()).hasNext()) {
            class_3222 player = (class_3222)iterator.next();
            IPlayerAppearance app = ComponentManager.getPlayerDatas((class_1657)player).getAppearence();
            app.removeCloth(layerID);
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_27693(" is now naked in the cloth layer: " + layerID), true);
            ComponentManager.syncPlayerDatas((class_1657)player);
            return 1;
        }
        throw new SimpleCommandExceptionType((Message)new LiteralMessage("Layer not found with id: " + layerID)).create();
    }

    private static int Exec(CommandContext<class_2168> ctx, String action) throws CommandSyntaxException {
        Iterator iterator;
        Collection players = class_2186.method_9312(ctx, (String)"player");
        String clothID = StringArgumentType.getString(ctx, (String)"id");
        Optional<Cloth> cloth = ClothingLoader.instance.getCloth(clothID);
        if (cloth.isPresent() && (iterator = players.iterator()).hasNext()) {
            class_3222 player = (class_3222)iterator.next();
            IPlayerAppearance app = ComponentManager.getPlayerDatas((class_1657)player).getAppearence();
            switch (action) {
                case "unlock": {
                    app.unlockCloth(cloth.get());
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_27693(" have unlocked the cloth: " + clothID), true);
                    break;
                }
                case "lock": {
                    app.lockCLoth(cloth.get());
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_27693(" have lost the cloth: " + clothID), true);
                    break;
                }
                case "set": {
                    app.setCloth(cloth.get());
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"").method_10852(player.method_5476()).method_27693(" is now wearing: " + clothID), true);
                }
            }
            ComponentManager.syncPlayerDatas((class_1657)player);
            return 1;
        }
        throw new SimpleCommandExceptionType((Message)new LiteralMessage("Cloth not found with id: " + clothID)).create();
    }
}

