/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.commands;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.http.APIService;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.CosmeticsPackets;
import com.diamssword.characters.storage.ClothingLoader;
import com.diamssword.characters.storage.PlayerAppearance;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

public class SkinCommand {
    private static final SuggestionProvider<class_2168> SUGGESTION_PROVIDER = (context, builder) -> {
        if (((class_2168)context.getSource()).method_43737()) {
            Set<String> set = ComponentManager.getPlayerCharacter((class_1657)((class_2168)context.getSource()).method_44023()).getCharactersNames();
            return class_2172.method_9265(set, (SuggestionsBuilder)builder);
        }
        return class_2172.method_9253((String[])new String[0], (SuggestionsBuilder)builder);
    };

    public static void register(LiteralArgumentBuilder<class_2168> builder) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)builder.requires(ctx -> ctx.method_9259(2));
        LiteralArgumentBuilder add = (LiteralArgumentBuilder)class_2170.method_9247((String)"add").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"code", (ArgumentType)StringArgumentType.string()).executes(SkinCommand::createExec1)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkinCommand::createExec1)));
        LiteralArgumentBuilder replace = (LiteralArgumentBuilder)class_2170.method_9247((String)"replace").then(class_2170.method_9244((String)"character", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"code", (ArgumentType)StringArgumentType.string()).executes(SkinCommand::replaceExec)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkinCommand::replaceExec))));
        LiteralArgumentBuilder switc = (LiteralArgumentBuilder)class_2170.method_9247((String)"switch").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"character", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(SkinCommand::switchExec)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkinCommand::switchExec)));
        LiteralArgumentBuilder remov = (LiteralArgumentBuilder)class_2170.method_9247((String)"delete").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"character", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(SkinCommand::removeExec)).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(SkinCommand::removeExec)));
        root.then((ArgumentBuilder)add);
        root.then((ArgumentBuilder)replace);
        root.then((ArgumentBuilder)switc);
        root.then((ArgumentBuilder)remov);
    }

    private static int switchExec(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 entity = ((class_2168)ctx.getSource()).method_44023();
        try {
            entity = class_2186.method_9315(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"character");
        if (entity != null) {
            ICharacterSheets chs = ComponentManager.getPlayerCharacter((class_1657)entity);
            if (chs.getCharactersNames().contains(sub)) {
                if (sub.equals(chs.getCurrentCharacterID())) {
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("This character is already  the current character: " + chs.getCurrentCharacterID())), true);
                    return 1;
                }
                chs.switchCharacter(sub);
                IPlayerAppearance iPlayerAppearance = ComponentManager.getPlayerDatas((class_1657)entity).getAppearence();
                if (iPlayerAppearance instanceof PlayerAppearance) {
                    PlayerAppearance ap = (PlayerAppearance)iPlayerAppearance;
                    ap.refreshSkinData();
                }
                Channels.MAIN.serverHandle(((class_2168)ctx.getSource()).method_9211()).send(new CosmeticsPackets.RefreshSkin(entity.method_7334().getId()));
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Character applied: " + chs.getCurrentCharacterID())), true);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("No character found: " + sub)), true);
        }
        return -1;
    }

    private static int removeExec(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 entity = ((class_2168)ctx.getSource()).method_44023();
        try {
            entity = class_2186.method_9315(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"character");
        if (entity != null) {
            ICharacterSheets chs = ComponentManager.getPlayerCharacter((class_1657)entity);
            if (chs.getCharactersNames().contains(sub)) {
                chs.deleteCharacter(sub);
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Character ereased: " + sub)), true);
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("No character found: " + sub)), true);
        }
        return -1;
    }

    private static int createExec1(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 entity = ((class_2168)ctx.getSource()).method_44023();
        try {
            entity = class_2186.method_9315(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"code");
        if (entity != null) {
            class_3222 finalEntity = entity;
            APIService.importCharacter((class_1657)entity, sub).handle((b, t) -> {
                if (t != null) {
                    t.printStackTrace();
                }
                if (b.isPresent()) {
                    ICharacterSheets chs = ComponentManager.getPlayerCharacter((class_1657)finalEntity);
                    chs.switchCharacter(chs.addNewCharacter((ApiCharacterValues)b.get()));
                    SkinCommand.setNewProfileDatas((ApiCharacterValues)b.get(), (class_1657)finalEntity);
                    IPlayerAppearance patt5709$temp = ComponentManager.getPlayerDatas((class_1657)finalEntity).getAppearence();
                    if (patt5709$temp instanceof PlayerAppearance) {
                        PlayerAppearance ap = (PlayerAppearance)patt5709$temp;
                        ap.refreshSkinData();
                    }
                    Channels.MAIN.serverHandle(((class_2168)ctx.getSource()).method_9211()).send(new CosmeticsPackets.RefreshSkin(finalEntity.method_7334().getId()));
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("New character successfully applied: " + chs.getCurrentCharacterID())), true);
                    return 1;
                }
                ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Error, please try again"), true);
                return -1;
            });
            return 1;
        }
        return 0;
    }

    private static void setNewProfileDatas(ApiCharacterValues character, class_1657 player) {
        IPlayerComponent dts = ComponentManager.getPlayerDatas(player);
        character.stats.points.forEach((k, v) -> dts.getStats().setLevel((String)k, (int)v));
        character.appearance.additional.forEach((k, v) -> {
            Optional<Cloth> cloth = ClothingLoader.instance.getCloth(k + "_" + v);
            cloth.ifPresent(c -> {
                if (c.layer().isBaseLayer()) {
                    dts.getAppearence().setCloth((Cloth)c);
                }
            });
        });
    }

    private static int replaceExec(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 entity = ((class_2168)ctx.getSource()).method_44023();
        try {
            entity = class_2186.method_9315(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"code");
        String chara = StringArgumentType.getString(ctx, (String)"character");
        if (entity != null) {
            class_3222 finalEntity = entity;
            ICharacterSheets chs = ComponentManager.getPlayerCharacter((class_1657)entity);
            if (chs.getCharactersNames().contains(chara)) {
                APIService.importCharacter((class_1657)entity, sub).handle((b, t) -> {
                    if (t != null) {
                        t.printStackTrace();
                    }
                    if (b.isPresent()) {
                        chs.replaceCharacter(chara, (ApiCharacterValues)b.get());
                        chs.switchCharacter(chara);
                        SkinCommand.setNewProfileDatas((ApiCharacterValues)b.get(), (class_1657)finalEntity);
                        IPlayerAppearance patt7594$temp = ComponentManager.getPlayerDatas((class_1657)finalEntity).getAppearence();
                        if (patt7594$temp instanceof PlayerAppearance) {
                            PlayerAppearance ap = (PlayerAppearance)patt7594$temp;
                            ap.refreshSkinData();
                        }
                        Channels.MAIN.serverHandle(((class_2168)ctx.getSource()).method_9211()).send(new CosmeticsPackets.RefreshSkin(finalEntity.method_7334().getId()));
                        ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Character replaced successfully: " + chs.getCurrentCharacterID())), true);
                        return 1;
                    }
                    ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)"Error, please try again"), true);
                    return -1;
                });
                return 1;
            }
            ((class_2168)ctx.getSource()).method_9226(() -> class_2561.method_43470((String)("Aucun personnage trouv\u00e9: " + chara)), true);
            return -1;
        }
        return 0;
    }
}

