/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.http;

import com.diamssword.characters.Characters;
import com.diamssword.characters.Utils;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.datafixers.util.Pair;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import net.minecraft.class_1657;

public class APIService {
    private static String token;

    public static CompletableFuture<Boolean> login() {
        JsonObject ob = new JsonObject();
        ob.addProperty("key", Characters.config.serverOptions.ServerSideApiKey);
        return APIService.postRequest(Characters.config.serverOptions.SkinServerURL + "/api/auth", "", ob).thenApply(rep -> {
            System.out.println(Characters.config.serverOptions.ServerSideApiKey);
            if (rep.statusCode() == 200) {
                token = JsonParser.parseString((String)((String)rep.body())).getAsJsonObject().get("token").getAsString();
                return true;
            }
            return false;
        });
    }

    public static CompletableFuture<Optional<ApiCharacterValues>> importCharacter(class_1657 player, String code) {
        JsonObject ob = new JsonObject();
        ob.addProperty("code", code);
        ob.addProperty("uuid", player.method_7334().getId().toString());
        return APIService.postRequest(Characters.config.serverOptions.SkinServerURL + "/api/player/validate", token, ob).thenApply(v -> {
            if (v.statusCode() != 200) {
                try {
                    return (Optional)((CompletableFuture)APIService.login().thenApply(c -> {
                        if (!c.booleanValue()) {
                            return Optional.empty();
                        }
                        try {
                            return APIService.importCharacter(player, code).get();
                        }
                        catch (InterruptedException | ExecutionException e) {
                            return Optional.empty();
                        }
                    })).get();
                }
                catch (InterruptedException | ExecutionException e) {
                    return Optional.empty();
                }
            }
            ApiCharacterValues val = (ApiCharacterValues)new Gson().fromJson((String)v.body(), ApiCharacterValues.class);
            return Optional.of(val);
        });
    }

    public static CompletableFuture<Optional<Pair<Boolean, UUID>>> getInfosForUsername(String name) {
        return APIService.getRequest(Characters.config.serverOptions.SkinServerURL + "/api/player/get/" + name, null).thenApply(v -> {
            if (v.statusCode() == 200) {
                JsonElement s = JsonParser.parseString((String)((String)v.body()));
                String uis = s.getAsJsonObject().get("uuid").getAsString();
                boolean b = s.getAsJsonObject().get("exist").getAsBoolean();
                return Optional.of(new Pair((Object)b, (Object)Utils.parseUUID(uis)));
            }
            return Optional.empty();
        });
    }

    public static CompletableFuture<HttpResponse<String>> getRequest(String url, String token) {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).GET().header("Content-Type", "application/json").header("Authorization", token == null ? "" : token).build();
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }

    public static CompletableFuture<HttpResponse<String>> postRequest(String url, String token, JsonObject body) {
        HttpClient client = HttpClient.newHttpClient();
        HttpRequest request = HttpRequest.newBuilder().uri(URI.create(url)).POST(HttpRequest.BodyPublishers.ofString(body.toString())).header("Content-Type", "application/json").header("Authorization", token == null ? "" : token).build();
        return client.sendAsync(request, HttpResponse.BodyHandlers.ofString());
    }
}

