/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.client.CharactersClient;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.DictionaryPackets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;

public class ClothingLoader
implements class_4013 {
    public static ClothingLoader instance = new ClothingLoader();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<String, Cloth> cloths = new HashMap<String, Cloth>();
    private Map<String, LayerDef> layers = new HashMap<String, LayerDef>();
    private final List<String> collections = new ArrayList<String>();
    private boolean shouldSync = false;

    public class_2960 getId() {
        return new class_2960(this.method_22322());
    }

    public Optional<Cloth> getCloth(String id) {
        return Optional.ofNullable(this.cloths.get(id));
    }

    public void addCloth(Cloth cloth) {
        this.cloths.put(cloth.layer().getId() + "_" + cloth.id(), cloth);
        this.shouldSync = true;
    }

    public void addLayer(LayerDef layer) {
        this.layers.put(layer.getId(), layer);
        this.shouldSync = true;
    }

    public List<String> getCollections() {
        return new ArrayList<String>(this.collections);
    }

    public List<Cloth> getClothsCollection(String collection) {
        return this.cloths.values().stream().filter(v -> collection.equals("all") || v.collection().equals(collection)).toList();
    }

    public List<String> getClothIds() {
        return this.cloths.keySet().stream().toList();
    }

    public List<LayerDef> getClothLayers() {
        return this.layers.values().stream().filter(v -> !v.isBodyPart()).toList();
    }

    public Optional<LayerDef> getLayer(String id) {
        return Optional.ofNullable(this.layers.get(id));
    }

    public Map<String, LayerDef> getLayers() {
        return this.layers;
    }

    public List<Cloth> getAvailablesClothsCollectionForPlayer(class_1657 ent, String collection, LayerDef ... layers) {
        List<String> lays = Arrays.stream(layers).map(LayerDef::getId).toList();
        if (ent.method_7337()) {
            return this.cloths.values().stream().filter(v -> (collection.equals("all") || v.collection().equals(collection)) && lays.contains(v.layer().getId())).toList();
        }
        ArrayList<String> unl = ComponentManager.getPlayerDatas(ent).getAppearence().getUnlockedCloths();
        return this.cloths.values().stream().filter(v -> (collection.equals("all") || v.collection().equals(collection)) && lays.contains(v.layer().getId()) && unl.contains(v.layer().getId() + "_" + v.id())).toList();
    }

    public List<Cloth> getForLayers(LayerDef ... layers) {
        ArrayList<Cloth> res = new ArrayList<Cloth>();
        List<String> ls = Arrays.stream(layers).map(LayerDef::getId).toList();
        this.cloths.forEach((k, v) -> {
            if (ls.contains(v.layer().getId())) {
                res.add((Cloth)v);
            }
        });
        return res;
    }

    public String method_22322() {
        return "character_sheet:cloths";
    }

    private void loadCLoths(JsonArray array) {
        array.forEach(v -> {
            JsonObject ob = v.getAsJsonObject();
            if (ob.has("id")) {
                String id1 = ob.get("layer").getAsString() + "_" + ob.get("id").getAsString();
                if (!this.cloths.containsKey(id1)) {
                    if (ob.has("layer") && ob.has("name")) {
                        LayerDef lay;
                        String col = "default";
                        if (ob.has("collection")) {
                            col = ob.get("collection").getAsString();
                        }
                        if ((lay = this.layers.get(ob.get("layer").getAsString())) != null) {
                            Cloth table = new Cloth(ob.get("id").getAsString(), ob.get("name").getAsString(), lay, col);
                            if (!this.collections.contains(col)) {
                                this.collections.add(col);
                            }
                            this.cloths.put(id1, table);
                        } else {
                            LOGGER.error("Layer for clothing with id: {} can't be parsed (layer {})", (Object)id1, (Object)ob.get("layer"));
                        }
                    } else {
                        LOGGER.error("Missing name of layer for clothing with id: {}", (Object)id1);
                    }
                } else {
                    LOGGER.error("Duplicate id for clothing: {}", (Object)id1);
                }
            } else {
                LOGGER.error("Clothing is missing ID!");
            }
        });
    }

    private void loadLayers(JsonArray array) {
        array.forEach(v -> {
            JsonObject ob = v.getAsJsonObject();
            if (ob.has("id")) {
                String id = ob.get("id").getAsString();
                if (!this.layers.containsKey(id)) {
                    if (ob.has("layer1")) {
                        try {
                            LayerDef layer = new LayerDef(id, ob.get("layer1").getAsInt());
                            if (ob.has("layer1")) {
                                layer.setLayer2(ob.get("layer1").getAsInt());
                            }
                            if (ob.has("forced")) {
                                layer.setForced(ob.get("forced").getAsBoolean());
                            }
                            if (ob.has("baseLayer")) {
                                layer.setBaseLayer(ob.get("baseLayer").getAsBoolean());
                            }
                            if (ob.has("bodyPart")) {
                                layer.setBodyPart(ob.get("bodyPart").getAsBoolean());
                            }
                            if (ob.has("displayMode")) {
                                layer.setDisplayMode(ob.get("displayMode").getAsInt());
                            }
                            if (ob.has("specialEditor")) {
                                layer.setSpecialEditor(ob.get("specialEditor").getAsString());
                            }
                            this.layers.put(id, layer);
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.error("Layer definition with id: {} can't be parsed ", (Object)id);
                        }
                    } else {
                        LOGGER.error("Layer {} is missing a layer1 field", (Object)id);
                    }
                } else {
                    LOGGER.error("Duplicate id for layer: {}", (Object)id);
                }
            } else {
                LOGGER.error("Layer is missing ID!");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void method_14491(class_3300 manager) {
        class_2960 id;
        Optional file;
        this.cloths = new HashMap<String, Cloth>();
        this.collections.clear();
        this.layers.clear();
        class_2960 idL = Characters.asRessource("layers.json");
        Optional fileL = manager.method_14486(idL);
        if (fileL.isPresent()) {
            try {
                BufferedReader reader = ((class_3298)fileL.get()).method_43039();
                try {
                    JsonArray jsonElement = (JsonArray)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonArray.class);
                    this.loadLayers(jsonElement);
                }
                finally {
                    ((Reader)reader).close();
                    this.shouldSync = true;
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{idL, this.method_22322(), exception});
            }
        }
        if ((file = manager.method_14486(id = Characters.asRessource("cloths.json"))).isPresent()) {
            try {
                BufferedReader reader = ((class_3298)file.get()).method_43039();
                try {
                    JsonArray jsonElement = (JsonArray)class_3518.method_15276((Gson)GSON, (Reader)reader, JsonArray.class);
                    this.loadCLoths(jsonElement);
                }
                finally {
                    ((Reader)reader).close();
                    this.shouldSync = true;
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, this.method_22322(), exception});
            }
        }
    }

    public void worldTick(MinecraftServer server) {
        if (this.shouldSync) {
            this.shouldSync = false;
            Channels.serverHandle(server).send(new DictionaryPackets.ClothingList(this));
            if (server.method_3724()) {
                CharactersClient.reloadPlayerRender();
            }
        }
    }

    public static void serializer(class_2540 write, ClothingLoader val) {
        class_2499 lays = new class_2499();
        class_2499 list = new class_2499();
        class_2499 collection = new class_2499();
        val.layers.forEach((u, v) -> lays.add((Object)v.toNBT()));
        val.cloths.forEach((u, v) -> {
            class_2487 v1 = v.toNBT();
            v1.method_10582("id", u);
            v1.method_10582("texture", v.id());
            list.add((Object)v1);
        });
        val.collections.forEach(c -> {
            class_2487 v1 = new class_2487();
            v1.method_10582("id", c);
            collection.add((Object)v1);
        });
        class_2487 comp = new class_2487();
        comp.method_10566("layers", (class_2520)lays);
        comp.method_10566("list", (class_2520)list);
        comp.method_10566("collection", (class_2520)collection);
        write.method_10794(comp);
    }

    public static ClothingLoader unserializer(class_2540 read) {
        ClothingLoader loader = new ClothingLoader();
        class_2487 comp = read.method_10798();
        class_2499 list = comp.method_10554("list", 10);
        class_2499 list1 = comp.method_10554("collection", 10);
        class_2499 lays = comp.method_10554("layers", 10);
        list1.forEach(c -> loader.collections.add(((class_2487)c).method_10558("id")));
        lays.forEach(el -> {
            LayerDef def = LayerDef.fromNBT((class_2487)el);
            if (def != null) {
                loader.layers.put(def.getId(), def);
            } else {
                LOGGER.error("Couldn't parse packet data for layer: {}", el);
            }
        });
        list.forEach(el -> {
            try {
                Cloth t;
                LayerDef lay = loader.layers.get(((class_2487)el).method_10558("layer"));
                if (lay != null && (t = Cloth.fromNBT((class_2487)el, ((class_2487)el).method_10558("texture"), lay)) != null) {
                    loader.cloths.put(((class_2487)el).method_10558("id"), t);
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't parse packet data for cloth: {}", el, (Object)e);
            }
        });
        return loader;
    }
}

