/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.api.http.ApiSkinValues;
import com.diamssword.characters.storage.ClothingLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import org.jetbrains.annotations.Nullable;

public class PlayerAppearance
implements IPlayerAppearance {
    private float scaledHeight = 1.0f;
    private final Map<String, Cloth> cloths = new HashMap<String, Cloth>();
    private final class_1657 parent;
    private final List<String> unlockedCloths = new ArrayList<String>();
    private final SavedOutfit[] outfits = new SavedOutfit[7];
    private ApiSkinValues skinDatas;

    public PlayerAppearance(class_1657 parent) {
        this.parent = parent;
        if (!parent.method_37908().field_9236 && parent.method_7334() != null) {
            this.refreshSkinData();
        }
    }

    public void tick() {
        if (this.skinDatas == null && !this.parent.method_37908().field_9236 && this.parent.field_6012 % 20 == 0 && this.parent.method_7334() != null) {
            this.refreshSkinData();
        }
    }

    public ApiSkinValues getSkinDatas() {
        return this.skinDatas;
    }

    public void refreshSkinData() {
        ICharacterSheets carM = ComponentManager.getPlayerCharacter(this.parent);
        if (carM != null && carM.getCurrentCharacter() != null) {
            this.skinDatas = carM.getCurrentCharacter().appearance;
            if (this.skinDatas != null) {
                this.scaledHeight = ApiSkinValues.HeightMToMCScale(1, this.skinDatas.size);
                ComponentManager.syncPlayerDatas(this.parent);
            }
        }
    }

    @Override
    public void clonePlayerAppearance(class_1657 sourcePlayer) {
        IPlayerAppearance car = ComponentManager.getPlayerDatas(sourcePlayer).getAppearence();
        if (car != null) {
            class_2487 tag = new class_2487();
            car.writeToNbt(tag, 0);
            this.readFromNbt(tag);
        }
    }

    @Override
    public void unlockCloth(Cloth cloth) {
        if (!this.unlockedCloths.contains(cloth.layer().id + "_" + cloth.id())) {
            this.unlockedCloths.add(cloth.layer().id + "_" + cloth.id());
        }
    }

    @Override
    public void lockCLoth(Cloth cloth) {
        this.unlockedCloths.remove(cloth.layer().id + "_" + cloth.id());
    }

    @Override
    public ArrayList<String> getUnlockedCloths() {
        return new ArrayList<String>(this.unlockedCloths);
    }

    @Override
    public Optional<Cloth> getEquippedCloth(LayerDef layer) {
        return Optional.ofNullable(this.cloths.get(layer.getId()));
    }

    @Override
    public Map<String, Cloth> getEquippedCloths() {
        HashMap<String, Cloth> res = new HashMap<String, Cloth>(this.cloths);
        for (LayerDef layer : ClothingLoader.instance.getClothLayers()) {
            if (res.containsKey(layer.getId())) continue;
            res.put(layer.getId(), null);
        }
        return res;
    }

    @Override
    public Map<String, Cloth> getEquippedLayers() {
        HashMap<String, Cloth> res = new HashMap<String, Cloth>(this.cloths);
        for (LayerDef layer : ClothingLoader.instance.getLayers().values()) {
            if (res.containsKey(layer.getId())) continue;
            res.put(layer.getId(), null);
        }
        return res;
    }

    private void fillForcedLayers() {
        ClothingLoader.instance.getLayers().values().stream().filter(LayerDef::isForced).forEach(la -> {
            List<Cloth> l;
            Optional<Cloth> und = this.getEquippedCloth((LayerDef)la);
            if (und.isEmpty() && !(l = ClothingLoader.instance.getForLayers((LayerDef)la)).isEmpty()) {
                this.setCloth(l.get(0));
            }
        });
    }

    public Optional<ClothData> getClothDatas(LayerDef layer) {
        return this.getEquippedCloth(layer).map(v -> new ClothData(v.id(), false, -1));
    }

    @Override
    public boolean equipCloth(Cloth cloth) {
        if (cloth == null) {
            return false;
        }
        if (this.parent.method_37908().field_9236 || this.parent.method_7337() || this.unlockedCloths.contains(cloth.layer().getId() + "_" + cloth.id())) {
            this.setCloth(cloth.layer().id, cloth);
            return true;
        }
        return false;
    }

    @Override
    public void setCloth(String layer, @Nullable Cloth cloth) {
        if (cloth == null) {
            ClothingLoader.instance.getLayer(layer).ifPresent(l -> {
                if (!l.isForced()) {
                    this.cloths.remove(layer);
                }
            });
        } else {
            this.cloths.put(layer, cloth);
        }
        if (this.parent instanceof class_3222) {
            ComponentManager.syncPlayerDatas(this.parent);
        }
    }

    @Override
    public void setCloth(Cloth cloth) {
        if (cloth != null) {
            this.setCloth(cloth.layer().getId(), cloth);
        }
    }

    @Override
    public void removeCloth(String layer) {
        this.setCloth(layer, null);
    }

    @Override
    public void saveOutfit(String name, int index) {
        if (index < this.outfits.length && index >= 0) {
            this.outfits[index] = new SavedOutfit(name, this);
            this.outfits[index].populate();
        }
    }

    @Override
    public List<class_3545<String, Integer>> getOutfits() {
        ArrayList<class_3545<String, Integer>> res = new ArrayList<class_3545<String, Integer>>();
        for (int i = 0; i < this.outfits.length; ++i) {
            if (this.outfits[i] == null) continue;
            res.add((class_3545<String, Integer>)new class_3545((Object)this.outfits[i].name, (Object)i));
        }
        return res;
    }

    @Override
    public void equipOutfit(int index) {
        if (index < this.outfits.length && index >= 0 && this.outfits[index] != null) {
            this.outfits[index].equipe();
        }
    }

    @Override
    public float getHeightScale() {
        return Math.max(0.8f, Math.min(1.1f, this.scaledHeight));
    }

    @Override
    public void readFromNbt(class_2487 tag) {
        class_2487 cl;
        if (tag.method_10545("default")) {
            this.skinDatas = new ApiSkinValues().fromNBT(tag.method_10562("default"));
            this.scaledHeight = ApiSkinValues.HeightMToMCScale(1, this.skinDatas.size);
        }
        if (tag.method_10545("cloths")) {
            this.cloths.clear();
            cl = tag.method_10562("cloths");
            cl.method_10541().forEach(k -> {
                try {
                    Optional<Cloth> cl1 = ClothingLoader.instance.getCloth(cl.method_10558(k));
                    cl1.ifPresent(v -> this.cloths.put(v.layer().getId(), (Cloth)v));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (tag.method_10545("unlockedCloths")) {
            this.unlockedCloths.clear();
            cl = tag.method_10554("unlockedCloths", 10);
            cl.forEach(k -> this.unlockedCloths.add(((class_2487)k).method_10558("id")));
        }
        if (tag.method_10545("outfits")) {
            cl = tag.method_10554("outfits", 10);
            for (int i = 0; i < cl.size(); ++i) {
                if (i >= this.outfits.length) continue;
                this.outfits[i] = ((class_2487)cl.method_10534(i)).method_33133() ? null : new SavedOutfit("", this).fromNBT((class_2487)cl.method_10534(i));
            }
        }
        this.fillForcedLayers();
    }

    @Override
    public class_2487 writeToNbt(class_2487 tag, int mode) {
        if (this.skinDatas != null && mode == 1) {
            tag.method_10566("default", (class_2520)this.skinDatas.toNBT());
        }
        class_2487 cloths = new class_2487();
        class_2499 unlocked = new class_2499();
        this.unlockedCloths.forEach(v -> {
            class_2487 t = new class_2487();
            t.method_10582("id", v);
            unlocked.add((Object)t);
        });
        this.cloths.forEach((i, v) -> cloths.method_10582(i, v.layer().getId() + "_" + v.id()));
        tag.method_10566("unlockedCloths", (class_2520)unlocked);
        tag.method_10566("cloths", (class_2520)cloths);
        class_2499 outLs = new class_2499();
        for (SavedOutfit outfit : this.outfits) {
            if (outfit != null) {
                outLs.add((Object)outfit.toNBT());
                continue;
            }
            outLs.add((Object)new class_2487());
        }
        tag.method_10566("outfits", (class_2520)outLs);
        return tag;
    }

    @Override
    public void onCharacterLoad(class_1657 player, String newCharacterID, ApiCharacterValues newCharacter, @Nullable String oldCharacterID) {
        this.refreshSkinData();
    }

    public static class_2487 serializer(IPlayerAppearance instance) {
        class_2487 res = new class_2487();
        instance.writeToNbt(res, 0);
        return res;
    }

    public static void unserializer(IPlayerAppearance instance, class_2487 tag) {
        instance.readFromNbt(tag);
    }

    public static class SavedOutfit {
        public List<String> cloths = new ArrayList<String>();
        public String name;
        public final PlayerAppearance parent;

        public SavedOutfit(String name, PlayerAppearance parent) {
            this.name = name;
            this.parent = parent;
        }

        public void populate() {
            this.cloths.clear();
            this.parent.getEquippedCloths().forEach((l, c) -> {
                if (c != null) {
                    this.cloths.add(c.layer().getId() + "_" + c.id());
                }
            });
        }

        public SavedOutfit fromNBT(class_2487 tag) {
            this.name = tag.method_10558("name");
            class_2499 ls = tag.method_10554("cloths", 10);
            ls.forEach(v -> this.cloths.add(((class_2487)v).method_10558("id")));
            return this;
        }

        public class_2487 toNBT() {
            class_2487 res = new class_2487();
            res.method_10582("name", this.name);
            class_2499 ls = new class_2499();
            this.cloths.forEach(c -> {
                class_2487 c1 = new class_2487();
                c1.method_10582("id", c);
                ls.add((Object)c1);
            });
            res.method_10566("cloths", (class_2520)ls);
            return res;
        }

        public void equipe() {
            this.cloths.forEach(v -> ClothingLoader.instance.getCloth((String)v).ifPresent(this.parent::equipCloth));
        }
    }

    public record ClothData(String texture, boolean needColor, int color) {
    }
}

