/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.ICharacterStored;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.network.SkinServerCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class PlayerCharacters
implements ICharacterSheets {
    private static final Map<class_2960, StorageGlobal> globalRegister = new HashMap<class_2960, StorageGlobal>();
    protected final class_1657 player;
    protected final Map<class_2960, Storage> registered = new HashMap<class_2960, Storage>();
    protected final Map<String, ApiCharacterValues> characters = new HashMap<String, ApiCharacterValues>();
    protected final Map<String, class_2487> storedDatas = new HashMap<String, class_2487>();
    protected String currentCharID;
    protected ApiCharacterValues currentCharacter;

    public PlayerCharacters(class_1657 e) {
        this.player = e;
        if (e instanceof class_3222) {
            class_3222 pl = (class_3222)e;
            globalRegister.forEach((k, v) -> this.attachComponent((class_2960)k, () -> v.provider.apply(pl), () -> v.serializer.apply(v.provider.apply(pl)), t -> v.unserializer.accept(v.provider.apply(pl), (class_2487)t)));
        }
    }

    @Override
    public Set<String> getCharactersNames() {
        return this.characters.keySet();
    }

    @Override
    public ApiCharacterValues getCurrentCharacter() {
        return this.currentCharacter;
    }

    @Override
    public String getCurrentCharacterID() {
        return this.currentCharID;
    }

    @Override
    public void switchCharacter(String id) {
        ApiCharacterValues car = this.characters.get(id);
        String oldChar = this.currentCharID;
        if (car != null) {
            this.currentCharacter = car;
            this.currentCharID = id;
            class_2487 oldCharSave = new class_2487();
            class_2487 newStore = this.storedDatas.getOrDefault(id, new class_2487());
            this.registered.forEach((i, s) -> {
                if (oldChar != null) {
                    oldCharSave.method_10566(i.toString(), (class_2520)s.serializer.get());
                }
                if (newStore.method_10545(i.toString())) {
                    s.unserializer.accept(newStore.method_10562(i.toString()));
                }
                s.instance.get().onCharacterLoad(this.player, id, car, oldChar);
            });
            if (oldChar != null) {
                this.storedDatas.put(oldChar, oldCharSave);
            }
            SkinServerCache.get(this.player.method_5682()).addToCache(this.player.method_5667(), car.base64Skin, car.base64SkinHead, car.appearance.slim);
            ComponentManager.syncPlayerCharacter(this.player);
            SkinServerCache.get(this.player.method_5682()).setActiveCharacter(this.player, this.currentCharacter.stats.firstname + " " + this.currentCharacter.stats.lastname, this.currentCharacter.base64SkinHead);
        }
    }

    @Override
    public void deleteCharacter(String id) {
        this.characters.remove(id);
        this.storedDatas.remove(id);
        if (id.equals(this.currentCharID)) {
            this.currentCharID = null;
        }
    }

    @Override
    public String addNewCharacter(ApiCharacterValues character) {
        String id = character.stats.firstname.toLowerCase().replaceAll(" ", "") + "_" + character.stats.lastname.toLowerCase().replaceAll(" ", "");
        int i = 1;
        String itid = id;
        while (this.characters.containsKey(itid)) {
            itid = id + i;
            ++i;
        }
        this.characters.put(itid, character);
        return itid;
    }

    @Override
    public void replaceCharacter(String id, ApiCharacterValues character) {
        this.characters.put(id, character);
        this.storedDatas.remove(id);
    }

    @Override
    public void attachComponent(class_2960 id, Supplier<ICharacterStored> instance, Supplier<class_2487> serializer, Consumer<class_2487> unserializer) {
        this.registered.put(id, new Storage(instance, serializer, unserializer));
    }

    @Override
    public void unattachComponent(class_2960 id) {
        this.registered.remove(id);
    }

    public static <T extends ICharacterStored> void attachComponentToCharacters(class_2960 id, Function<class_3222, T> provider, Function<T, class_2487> serializer, BiConsumer<T, class_2487> unserializer) {
        globalRegister.put(id, new StorageGlobal(provider, serializer, unserializer));
        Characters.LOGGER.info("Attached Character Sheet Component: {}", (Object)id);
    }

    public static void unattachComponentFromCharacters(class_2960 id) {
        globalRegister.remove(id);
    }

    protected record Storage(Supplier<ICharacterStored> instance, Supplier<class_2487> serializer, Consumer<class_2487> unserializer) {
    }

    protected record StorageGlobal(Function<class_3222, ICharacterStored> provider, Function<ICharacterStored, class_2487> serializer, BiConsumer<ICharacterStored, class_2487> unserializer) {
    }
}

