/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.api.stats.IPlayerStats;
import com.diamssword.characters.api.stats.StatsRole;
import com.diamssword.characters.storage.ClassesLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import org.jetbrains.annotations.Nullable;

public class PlayerStats
implements IPlayerStats {
    private final Map<String, Integer> stats = new HashMap<String, Integer>();
    private final Map<String, Integer> storedXP = new HashMap<String, Integer>();
    public final class_1657 player;

    public PlayerStats(class_1657 parent) {
        this.player = parent;
    }

    @Override
    public void readFromNbt(class_2487 nbt) {
        class_2487 st = nbt.method_10562("stats");
        Map<String, StatsRole> ls = ClassesLoader.getRoles();
        st.method_10541().forEach(k -> {
            if (ls.containsKey(k)) {
                this.stats.put((String)k, st.method_10550(k));
            }
        });
        class_2487 xps = nbt.method_10562("xp");
        xps.method_10541().forEach(k -> {
            try {
                if (ls.containsKey(k)) {
                    this.storedXP.put((String)k, xps.method_10550(k));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        if (!this.player.method_37908().field_9236) {
            this.onPlayerRespawn();
        }
    }

    @Override
    public class_2487 writeToNbt() {
        class_2487 nbt = new class_2487();
        class_2487 nbt2 = new class_2487();
        class_2487 nbt1 = new class_2487();
        this.stats.forEach((arg_0, arg_1) -> ((class_2487)nbt1).method_10569(arg_0, arg_1));
        this.storedXP.forEach((arg_0, arg_1) -> ((class_2487)nbt2).method_10569(arg_0, arg_1));
        nbt.method_10566("stats", (class_2520)nbt1);
        nbt.method_10566("xp", (class_2520)nbt2);
        return nbt;
    }

    @Override
    public int getLevel(String main) {
        return this.stats.getOrDefault(main, 0);
    }

    @Override
    public int getPalier(String main) {
        Integer v = this.stats.getOrDefault(main, 0);
        Optional<StatsRole> c = ClassesLoader.getRole(main);
        return c.map(statsRole -> statsRole.getPalierForLevel(v)).orElse(0);
    }

    @Override
    public int getXp(String role) {
        return this.storedXP.getOrDefault(role, 0);
    }

    @Override
    public void setLevel(String role, int count) {
        this.stats.put(role, count);
        ClassesLoader.onLevelChange(this.player, role, count);
    }

    @Override
    public void setXp(String role, int count) {
        int l = this.getLevel(role);
        int nex = ClassesLoader.instance.getXpCostForLevel(l + 1);
        if (nex > 0 && count >= nex) {
            this.setLevel(role, l + 1);
            count -= nex;
        }
        this.storedXP.put(role, count);
    }

    @Override
    public int getOrCreate(String main, int level) {
        if (!this.stats.containsKey(main)) {
            this.stats.put(main, level);
        }
        return this.stats.get(main);
    }

    public void onPlayerRespawn() {
        for (Map.Entry<String, Integer> item : this.stats.entrySet()) {
            ClassesLoader.onLevelChange(this.player, item.getKey(), item.getValue());
        }
    }

    @Override
    public void onCharacterLoad(class_1657 player, String newCharacterID, ApiCharacterValues newCharacter, @Nullable String oldCharacterID) {
    }

    public static class_2487 serializer(IPlayerStats instance) {
        return instance.writeToNbt();
    }

    public static void unserializer(IPlayerStats instance, class_2487 tag) {
        instance.readFromNbt(tag);
    }
}

