/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Base64;
import java.util.concurrent.CompletableFuture;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class B64PlayerSkinTexture
extends SimpleTexture {
    private static final Logger LOGGER = LogUtils.getLogger();
    @Nullable
    private final File cacheFile;
    private final String base64;
    @Nullable
    private final Runnable loadedCallback;
    @Nullable
    private CompletableFuture<?> loader;
    private boolean loaded;

    public B64PlayerSkinTexture(@Nullable File cacheFile, String base64, ResourceLocation fallbackSkin, @Nullable Runnable callback) {
        super(fallbackSkin);
        this.cacheFile = cacheFile;
        this.base64 = base64;
        this.loadedCallback = callback;
    }

    private void onTextureLoaded(NativeImage image) {
        if (this.loadedCallback != null) {
            this.loadedCallback.run();
        }
        Minecraft.m_91087_().execute(() -> {
            this.loaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.uploadTexture(image));
            } else {
                this.uploadTexture(image);
            }
        });
    }

    private void uploadTexture(NativeImage image) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)image.m_84982_(), (int)image.m_85084_());
        image.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(ResourceManager manager) throws IOException {
        Minecraft.m_91087_().execute(() -> {
            if (!this.loaded) {
                try {
                    super.m_6704_(manager);
                }
                catch (IOException var3x) {
                    LOGGER.warn("Failed to load texture: {}", (Object)this.f_118129_, (Object)var3x);
                }
                this.loaded = true;
            }
        });
        if (this.loader == null) {
            NativeImage nativeImage;
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                LOGGER.debug("Loading http texture from local cache ({})", (Object)this.cacheFile);
                FileInputStream fileInputStream = new FileInputStream(this.cacheFile);
                nativeImage = this.loadTexture(fileInputStream);
            } else {
                nativeImage = null;
            }
            if (nativeImage != null) {
                this.onTextureLoaded(nativeImage);
            } else {
                this.loader = CompletableFuture.runAsync(() -> {
                    LOGGER.debug("Getting base64 texture from {} to {}", (Object)this.base64, (Object)this.cacheFile);
                    try {
                        InputStream inputStream = this.base64ToString(this.base64);
                        if (this.cacheFile != null && inputStream != null) {
                            FileUtils.copyInputStreamToFile((InputStream)inputStream, (File)this.cacheFile);
                            inputStream = new FileInputStream(this.cacheFile);
                        }
                        InputStream finalInputStream = inputStream;
                        Minecraft.m_91087_().execute(() -> {
                            NativeImage nativeImagex = this.loadTexture(finalInputStream);
                            if (nativeImagex != null) {
                                this.onTextureLoaded(nativeImagex);
                            }
                        });
                    }
                    catch (Exception var6) {
                        LOGGER.error("Couldn't download http texture", (Throwable)var6);
                    }
                }, Util.m_183991_());
            }
        }
    }

    @Nullable
    private NativeImage loadTexture(InputStream stream) {
        NativeImage nativeImage = null;
        try {
            nativeImage = NativeImage.m_85058_((InputStream)stream);
        }
        catch (Exception var4) {
            LOGGER.warn("Error while loading the skin texture", (Throwable)var4);
        }
        return nativeImage;
    }

    @Nullable
    private InputStream base64ToString(String base64String) {
        ByteArrayInputStream byteArrayInputStream;
        byte[] imageBytes = Base64.getDecoder().decode(base64String);
        ByteArrayInputStream bais = new ByteArrayInputStream(imageBytes);
        try {
            byteArrayInputStream = bais;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                LOGGER.warn("Error while loading the base64 stream's texture", (Throwable)e);
                return null;
            }
        }
        bais.close();
        return byteArrayInputStream;
    }
}

