/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.client.ClothingModel;
import com.diamssword.characters.storage.PlayerAppearance;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Optional;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class ClothingLayer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private final RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> ctx;
    private final LayerDef layer;
    public final boolean altTexture;
    private final ClothingModel<AbstractClientPlayer> model;

    public ClothingLayer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> context, LayerDef layer, boolean altTexture, boolean thinArm) {
        super(context);
        this.ctx = context;
        this.altTexture = altTexture;
        this.layer = layer;
        this.model = new ClothingModel(thinArm, altTexture ? layer.getLayer2() : layer.getLayer1(), altTexture);
    }

    public void render(PoseStack matrices, MultiBufferSource vertexConsumers, int light, AbstractClientPlayer entity, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        PlayerAppearance ap;
        Optional<PlayerAppearance.ClothData> c1;
        IPlayerComponent data = ComponentManager.getPlayerDatas((Player)entity);
        IPlayerAppearance iPlayerAppearance = data.getAppearence();
        if (iPlayerAppearance instanceof PlayerAppearance && (c1 = (ap = (PlayerAppearance)iPlayerAppearance).getClothDatas(this.layer)).isPresent()) {
            PlayerAppearance.ClothData c = c1.get();
            ((PlayerModel)this.ctx.m_7200_()).m_102872_(this.model);
            this.model.m_6839_((LivingEntity)entity, limbAngle, limbDistance, tickDelta);
            Color col = new Color(255, 255, 255);
            if (c.needColor()) {
                col = new Color(c.color()).brighter();
            }
            this.model.m_7695_(matrices, vertexConsumers.m_6299_(this.model.m_103119_(Characters.asRessource("textures/cloth/" + this.layer.getId() + "/" + c.texture() + ".png"))), light, LivingEntityRenderer.m_115338_((LivingEntity)entity, (float)0.0f), (float)col.getRed() / 255.0f, (float)col.getGreen() / 255.0f, (float)col.getBlue() / 255.0f, 1.0f);
        }
    }
}

