/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client;

import com.google.common.collect.Iterables;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ClothingModel<T extends LivingEntity>
extends HumanoidModel<T> {
    private final boolean thinArms;

    public ClothingModel(boolean thinArms, int layer, boolean altTexture) {
        super(ClothingModel.getTexturedModelData(new CubeDeformation(0.04f + (float)layer * 0.04f), thinArms, altTexture).m_171564_(), RenderType::m_110473_);
        this.thinArms = thinArms;
        this.f_102809_.f_104207_ = false;
    }

    public static LayerDefinition getTexturedModelData(CubeDeformation dilation, boolean slim, boolean altTexture) {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.m_171576_();
        modelPartData.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(altTexture ? 32 : 0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, dilation.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, altTexture ? 32 : 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        modelPartData.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, altTexture ? 32 : 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        modelPartData.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(altTexture ? 0 : 16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, dilation), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        CubeDeformation dil = dilation;
        dil = dil.m_171471_(slim ? -0.25f : 0.15f, 0.0f, 0.0f);
        modelPartData.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(altTexture ? 48 : 32, 48).m_171488_(-1.0f + (slim ? -0.2f : 0.0f), -2.0f, -2.0f, 3.5f, 12.0f, 4.0f, dil), PartPose.m_171419_((float)5.0f, (float)2.5f, (float)0.0f));
        modelPartData.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, altTexture ? 32 : 16).m_171488_(-2.5f - (slim ? -0.2f : 0.15f), -2.0f, -2.0f, 3.5f, 12.0f, 4.0f, dil), PartPose.m_171419_((float)-5.0f, (float)2.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)modelData, (int)64, (int)64);
    }

    protected Iterable<ModelPart> m_5608_() {
        return Iterables.concat((Iterable[])new Iterable[]{super.m_5608_()});
    }

    public void m_6973_(T livingEntity, float f, float g, float h, float i, float j) {
        super.m_6973_(livingEntity, f, g, h, i, j);
    }

    public void m_8009_(boolean visible) {
        super.m_8009_(visible);
        this.f_102809_.f_104207_ = false;
    }

    public void m_6002_(HumanoidArm arm, PoseStack matrices) {
        ModelPart modelPart = this.m_102851_(arm);
        if (this.thinArms) {
            float f = 0.5f * (float)(arm == HumanoidArm.RIGHT ? 1 : -1);
            modelPart.f_104200_ += f;
            modelPart.m_104299_(matrices);
            modelPart.f_104200_ -= f;
        } else {
            modelPart.m_104299_(matrices);
        }
    }
}

