/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client;

import com.diamssword.characters.api.PlayerPresence;
import com.diamssword.characters.client.B64MinecraftProfileTexture;
import com.diamssword.characters.client.B64PlayerSkinTexture;
import com.diamssword.characters.client.ClientComesticsPacket;
import com.diamssword.characters.mixins.PlayerSkinProviderAccessor;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.SkinServerCache;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class SkinsLoader {
    public static final SkinServerCache clientSkinCache = new SkinServerCache();
    private final Set<UUID> needReload = new HashSet<UUID>();
    private final Set<UUID> requested = new HashSet<UUID>();
    private final Set<UUID> requestedOfflineHead = new HashSet<UUID>();
    private final Map<UUID, Set<Consumer<ResourceLocation>>> pendingOfflineheadRequest = new HashMap<UUID, Set<Consumer<ResourceLocation>>>();
    private final Map<UUID, ResourceLocation> offlineHeadCache = new HashMap<UUID, ResourceLocation>();
    private final File cacheDir = ((PlayerSkinProviderAccessor)Minecraft.m_91087_().m_91109_()).getCacheDir();
    public static SkinsLoader instance = new SkinsLoader();

    public boolean doesNeedReload(UUID playerid) {
        return this.needReload.contains(playerid);
    }

    public boolean markReload(UUID playerid, boolean needed) {
        if (needed) {
            this.requested.remove(playerid);
            this.offlineHeadCache.remove(playerid);
            this.needReload.add(playerid);
        } else if (this.needReload.contains(playerid)) {
            this.needReload.remove(playerid);
            return true;
        }
        return false;
    }

    public static void getHeadTexture(UUID playerID, Consumer<ResourceLocation> callback) {
        PlayerInfo profile = Minecraft.m_91087_().m_91403_().m_104949_(playerID);
        if (profile != null) {
            instance.loadSkin(profile.m_105312_().getId(), true, (a, b, c) -> callback.accept(b));
            return;
        }
        instance.getOfflineHead(playerID, callback);
    }

    public void loadSkinHeadOffline(UUID player, String base64) {
        Runnable runnable = () -> Minecraft.m_91087_().execute(() -> RenderSystem.recordRenderCall(() -> {
            B64MinecraftProfileTexture txt = new B64MinecraftProfileTexture(base64, new HashMap<String, String>());
            String string = Hashing.sha1().hashUnencodedChars((CharSequence)txt.getHash()).toString();
            ResourceLocation identifier = new ResourceLocation("heads/" + string);
            B64PlayerSkinTexture playerSkinTexture = new B64PlayerSkinTexture(null, base64, DefaultPlayerSkin.m_118626_(), () -> {
                this.offlineHeadCache.put(player, identifier);
                Set<Consumer<ResourceLocation>> k = this.pendingOfflineheadRequest.get(player);
                if (k != null) {
                    k.forEach(x -> x.accept(identifier));
                    this.pendingOfflineheadRequest.remove(player);
                }
            });
            Minecraft.m_91087_().m_91097_().m_118495_(identifier, (AbstractTexture)playerSkinTexture);
        }));
        Util.m_183991_().execute(runnable);
    }

    public void loadSkin(UUID userid, boolean isHead, SkinTextureAvailableCallback callback) {
        boolean force = this.markReload(userid, false);
        Runnable runnable = () -> Minecraft.m_91087_().execute(() -> RenderSystem.recordRenderCall(() -> {
            Optional<SkinServerCache.PlayerInfos> skin = clientSkinCache.getSkin(userid);
            if (skin.isPresent()) {
                this.requested.remove(userid);
                HashMap<String, String> map1 = new HashMap<String, String>();
                map1.put("slim", skin.get().slim() ? "true" : "false");
                this.loadSkin(new B64MinecraftProfileTexture(isHead ? skin.get().head() : skin.get().skin(), map1), callback, force, isHead ? "heads" : "skins");
            } else if (!this.requested.contains(userid)) {
                Channels.MAIN.clientHandle().send(new SkinServerCache.RequestPlayerInfos(userid));
                this.requested.add(userid);
            }
        }));
        Util.m_183991_().execute(runnable);
    }

    private void getOfflineHead(UUID userid, Consumer<ResourceLocation> callback) {
        Runnable runnable = () -> Minecraft.m_91087_().execute(() -> RenderSystem.recordRenderCall(() -> {
            ResourceLocation skin = this.offlineHeadCache.get(userid);
            if (skin != null) {
                this.requestedOfflineHead.remove(userid);
                callback.accept(this.offlineHeadCache.get(userid));
            } else if (!this.requestedOfflineHead.contains(userid)) {
                Channels.MAIN.clientHandle().send(new SkinServerCache.RequestPlayerPresence(userid));
                if (!this.pendingOfflineheadRequest.containsKey(userid)) {
                    this.pendingOfflineheadRequest.put(userid, new HashSet());
                }
                this.pendingOfflineheadRequest.get(userid).add(callback);
                this.requestedOfflineHead.add(userid);
            }
        }));
        Util.m_183991_().execute(runnable);
    }

    public void loadSkin(GameProfile profile, SkinTextureAvailableCallback callback) {
        this.loadSkin(profile.getId(), false, callback);
    }

    private ResourceLocation loadSkin(B64MinecraftProfileTexture profileTexture, @Nullable SkinTextureAvailableCallback callback, boolean force, String type) {
        String string = Hashing.sha1().hashUnencodedChars((CharSequence)profileTexture.getHash()).toString();
        ResourceLocation identifier = new ResourceLocation(type + "/" + string);
        AbstractTexture abstractTexture = Minecraft.m_91087_().m_91097_().m_174786_(identifier, (AbstractTexture)MissingTextureAtlasSprite.m_118080_());
        if (force || abstractTexture == MissingTextureAtlasSprite.m_118080_()) {
            File file = new File(this.cacheDir, string.length() > 2 ? string.substring(0, 2) : "xx");
            File file2 = new File(file, string);
            if (force && file2.exists()) {
                file2.delete();
            }
            B64PlayerSkinTexture playerSkinTexture = new B64PlayerSkinTexture(file2, profileTexture.getData(), DefaultPlayerSkin.m_118626_(), () -> {
                if (callback != null) {
                    callback.onSkinTextureAvailable(MinecraftProfileTexture.Type.SKIN, identifier, profileTexture);
                }
            });
            Minecraft.m_91087_().m_91097_().m_118495_(identifier, (AbstractTexture)playerSkinTexture);
        } else if (callback != null) {
            callback.onSkinTextureAvailable(MinecraftProfileTexture.Type.SKIN, identifier, profileTexture);
        }
        return identifier;
    }

    public static CompletableFuture<Map<UUID, PlayerPresence>> requestPlayerProfiles(String query) {
        Channels.MAIN.clientHandle().send(new SkinServerCache.RequestPlayersMatching(query));
        CompletableFuture<Map<UUID, PlayerPresence>> future = new CompletableFuture<Map<UUID, PlayerPresence>>();
        ClientComesticsPacket.PlayerProfilesRequestCallback = future::complete;
        return future;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static interface SkinTextureAvailableCallback {
        public void onSkinTextureAvailable(MinecraftProfileTexture.Type var1, ResourceLocation var2, B64MinecraftProfileTexture var3);
    }
}

