/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.commands;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.stats.IPlayerStats;
import com.diamssword.characters.storage.ClassesLoader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;

public class PStatsCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"add", "set"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER3 = (context, builder) -> SharedSuggestionProvider.m_82967_((String[])new String[]{"xp", "level"}, (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER1 = (context, builder) -> SharedSuggestionProvider.m_82970_(ClassesLoader.getRoles().keySet(), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        RequiredArgumentBuilder c1 = (RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"operation", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).then(Commands.m_82129_((String)"type", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER3).then(Commands.m_82129_((String)"cat", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER1).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer()).executes(PStatsCommand::modExec)))));
        RequiredArgumentBuilder c2 = (RequiredArgumentBuilder)Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"cat", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER1).executes(PStatsCommand::getExec)));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.requires(ctx -> ctx.m_6761_(2))).then((ArgumentBuilder)c1)).then((ArgumentBuilder)c2);
    }

    private static int getExec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(ctx, (String)"player");
        String cat = StringArgumentType.getString(ctx, (String)"cat");
        players.forEach(player -> {
            IPlayerStats stats = ComponentManager.getPlayerDatas((Player)player).getStats();
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " values for " + cat + ": Level[" + stats.getLevel(cat) + "] Xp[" + stats.getXp(cat) + "]")), false);
        });
        return 1;
    }

    private static int modExec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Collection players = EntityArgument.m_91477_(ctx, (String)"player");
        String op = StringArgumentType.getString(ctx, (String)"operation");
        String type = StringArgumentType.getString(ctx, (String)"type");
        String cat = StringArgumentType.getString(ctx, (String)"cat");
        int count = IntegerArgumentType.getInteger(ctx, (String)"count");
        if (ClassesLoader.getRoles().containsKey(cat)) {
            players.forEach(player -> {
                IPlayerStats stats = ComponentManager.getPlayerDatas((Player)player).getStats();
                stats.getOrCreate(cat, 0);
                if (type.equals("xp")) {
                    stats.setXp(cat, op.equals("set") ? count : stats.getXp(cat) + count);
                } else if (type.equals("level")) {
                    stats.setLevel(cat, op.equals("set") ? count : stats.getLevel(cat) + count);
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)(player.m_7755_().getString() + " " + cat + " value is now:  Level[" + stats.getLevel(cat) + "] Xp[" + stats.getXp(cat) + "]")), false);
                ComponentManager.syncPlayerDatas((Player)player);
            });
            return 1;
        }
        return 0;
    }
}

