/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.commands;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.http.APIService;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.CosmeticsPackets;
import com.diamssword.characters.storage.ClothingLoader;
import com.diamssword.characters.storage.PlayerAppearance;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class SkinCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> {
        if (((CommandSourceStack)context.getSource()).m_230897_()) {
            Set<String> set = ComponentManager.getPlayerCharacter((Player)((CommandSourceStack)context.getSource()).m_230896_()).getCharactersNames();
            return SharedSuggestionProvider.m_82970_(set, (SuggestionsBuilder)builder);
        }
        return SharedSuggestionProvider.m_82967_((String[])new String[0], (SuggestionsBuilder)builder);
    };

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)builder.requires(ctx -> ctx.m_6761_(2));
        LiteralArgumentBuilder add = (LiteralArgumentBuilder)Commands.m_82127_((String)"add").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"code", (ArgumentType)StringArgumentType.string()).executes(SkinCommand::createExec1)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(SkinCommand::createExec1)));
        LiteralArgumentBuilder replace = (LiteralArgumentBuilder)Commands.m_82127_((String)"replace").then(Commands.m_82129_((String)"character", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"code", (ArgumentType)StringArgumentType.string()).executes(SkinCommand::replaceExec)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(SkinCommand::replaceExec))));
        LiteralArgumentBuilder switc = (LiteralArgumentBuilder)Commands.m_82127_((String)"switch").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"character", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(SkinCommand::switchExec)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(SkinCommand::switchExec)));
        LiteralArgumentBuilder remov = (LiteralArgumentBuilder)Commands.m_82127_((String)"delete").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"character", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER).executes(SkinCommand::removeExec)).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).executes(SkinCommand::removeExec)));
        root.then((ArgumentBuilder)add);
        root.then((ArgumentBuilder)replace);
        root.then((ArgumentBuilder)switc);
        root.then((ArgumentBuilder)remov);
    }

    private static int switchExec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer entity = ((CommandSourceStack)ctx.getSource()).m_230896_();
        try {
            entity = EntityArgument.m_91474_(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"character");
        if (entity != null) {
            ICharacterSheets chs = ComponentManager.getPlayerCharacter((Player)entity);
            if (chs.getCharactersNames().contains(sub)) {
                if (sub.equals(chs.getCurrentCharacterID())) {
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("This character is already  the current character: " + chs.getCurrentCharacterID())), true);
                    return 1;
                }
                chs.switchCharacter(sub);
                IPlayerAppearance iPlayerAppearance = ComponentManager.getPlayerDatas((Player)entity).getAppearence();
                if (iPlayerAppearance instanceof PlayerAppearance) {
                    PlayerAppearance ap = (PlayerAppearance)iPlayerAppearance;
                    ap.refreshSkinData();
                }
                Channels.MAIN.serverHandle(((CommandSourceStack)ctx.getSource()).m_81377_()).send(new CosmeticsPackets.RefreshSkin(entity.m_36316_().getId()));
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Character applied: " + chs.getCurrentCharacterID())), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("No character found: " + sub)), true);
        }
        return -1;
    }

    private static int removeExec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer entity = ((CommandSourceStack)ctx.getSource()).m_230896_();
        try {
            entity = EntityArgument.m_91474_(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"character");
        if (entity != null) {
            ICharacterSheets chs = ComponentManager.getPlayerCharacter((Player)entity);
            if (chs.getCharactersNames().contains(sub)) {
                chs.deleteCharacter(sub);
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Character ereased: " + sub)), true);
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("No character found: " + sub)), true);
        }
        return -1;
    }

    private static int createExec1(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer entity = ((CommandSourceStack)ctx.getSource()).m_230896_();
        try {
            entity = EntityArgument.m_91474_(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"code");
        if (entity != null) {
            ServerPlayer finalEntity = entity;
            APIService.importCharacter((Player)entity, sub).handle((b, t) -> {
                if (t != null) {
                    t.printStackTrace();
                }
                if (b.isPresent()) {
                    ICharacterSheets chs = ComponentManager.getPlayerCharacter((Player)finalEntity);
                    chs.switchCharacter(chs.addNewCharacter((ApiCharacterValues)b.get()));
                    SkinCommand.setNewProfileDatas((ApiCharacterValues)b.get(), (Player)finalEntity);
                    IPlayerAppearance patt5709$temp = ComponentManager.getPlayerDatas((Player)finalEntity).getAppearence();
                    if (patt5709$temp instanceof PlayerAppearance) {
                        PlayerAppearance ap = (PlayerAppearance)patt5709$temp;
                        ap.refreshSkinData();
                    }
                    Channels.MAIN.serverHandle(((CommandSourceStack)ctx.getSource()).m_81377_()).send(new CosmeticsPackets.RefreshSkin(finalEntity.m_36316_().getId()));
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("New character successfully applied: " + chs.getCurrentCharacterID())), true);
                    return 1;
                }
                ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Error, please try again"), true);
                return -1;
            });
            return 1;
        }
        return 0;
    }

    private static void setNewProfileDatas(ApiCharacterValues character, Player player) {
        IPlayerComponent dts = ComponentManager.getPlayerDatas(player);
        character.stats.points.forEach((k, v) -> dts.getStats().setLevel((String)k, (int)v));
        character.appearance.additional.forEach((k, v) -> {
            Optional<Cloth> cloth = ClothingLoader.instance.getCloth(k + "_" + v);
            cloth.ifPresent(c -> {
                if (c.layer().isBaseLayer()) {
                    dts.getAppearence().setCloth((Cloth)c);
                }
            });
        });
    }

    private static int replaceExec(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerPlayer entity = ((CommandSourceStack)ctx.getSource()).m_230896_();
        try {
            entity = EntityArgument.m_91474_(ctx, (String)"player");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        String sub = StringArgumentType.getString(ctx, (String)"code");
        String chara = StringArgumentType.getString(ctx, (String)"character");
        if (entity != null) {
            ServerPlayer finalEntity = entity;
            ICharacterSheets chs = ComponentManager.getPlayerCharacter((Player)entity);
            if (chs.getCharactersNames().contains(chara)) {
                APIService.importCharacter((Player)entity, sub).handle((b, t) -> {
                    if (t != null) {
                        t.printStackTrace();
                    }
                    if (b.isPresent()) {
                        chs.replaceCharacter(chara, (ApiCharacterValues)b.get());
                        chs.switchCharacter(chara);
                        SkinCommand.setNewProfileDatas((ApiCharacterValues)b.get(), (Player)finalEntity);
                        IPlayerAppearance patt7594$temp = ComponentManager.getPlayerDatas((Player)finalEntity).getAppearence();
                        if (patt7594$temp instanceof PlayerAppearance) {
                            PlayerAppearance ap = (PlayerAppearance)patt7594$temp;
                            ap.refreshSkinData();
                        }
                        Channels.MAIN.serverHandle(((CommandSourceStack)ctx.getSource()).m_81377_()).send(new CosmeticsPackets.RefreshSkin(finalEntity.m_36316_().getId()));
                        ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Character replaced successfully: " + chs.getCurrentCharacterID())), true);
                        return 1;
                    }
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"Error, please try again"), true);
                    return -1;
                });
                return 1;
            }
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)("Aucun personnage trouv\u00e9: " + chara)), true);
            return -1;
        }
        return 0;
    }
}

