/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.config;

import com.diamssword.characters.Characters;
import com.diamssword.characters.config.Config;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.architectury.platform.Platform;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = Platform.getConfigFolder().resolve("character_sheet.json");

    public static void saveConfig(Config config) {
        try {
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)config), new OpenOption[0]);
        }
        catch (IOException e) {
            Characters.LOGGER.error((Object)e);
        }
    }

    public static Config loadConfig() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            Config defaultConfig = new Config();
            ConfigManager.saveConfig(defaultConfig);
            return defaultConfig;
        }
        try {
            String json = Files.readString(CONFIG_PATH);
            return (Config)GSON.fromJson(json, Config.class);
        }
        catch (IOException e) {
            return new Config();
        }
    }
}

