/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.forge;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.forge.CapabilityEvents;
import com.diamssword.characters.forge.ModNetworking;
import com.diamssword.characters.forge.SyncPlayerStatsPacket;
import com.diamssword.characters.network.SkinServerCache;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ComponentsImpl
extends ComponentManager {
    @Override
    public <T, A> T getComponent(A entity, Class<T> componentClass) {
        if (entity instanceof Player) {
            Player pl = (Player)entity;
            if (componentClass == IPlayerComponent.class) {
                return pl.getCapability(CapabilityEvents.PLAYER_APPEARANCE).resolve().get();
            }
            if (componentClass == ICharacterSheets.class) {
                return pl.getCapability(CapabilityEvents.PLAYER_CHARACTERS).resolve().get();
            }
        } else if (entity instanceof MinecraftServer) {
            MinecraftServer s = (MinecraftServer)entity;
            if (componentClass == SkinServerCache.class) {
                return s.m_129783_().getCapability(CapabilityEvents.SKIN_SERVER_CACHE).resolve().get();
            }
        }
        return null;
    }

    @Override
    public <T, A> void syncComponent(A entity, Class<T> componentClass) {
        if (entity instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)entity;
            if (pl.f_8906_ != null) {
                if (componentClass == IPlayerComponent.class) {
                    pl.getCapability(CapabilityEvents.PLAYER_APPEARANCE).ifPresent(v -> ModNetworking.syncToTracking(pl, new SyncPlayerStatsPacket((Player)pl, CapabilityEvents.APPEARANCE, false)));
                    pl.getCapability(CapabilityEvents.PLAYER_APPEARANCE).ifPresent(v -> ModNetworking.syncToClient(pl, new SyncPlayerStatsPacket((Player)pl, CapabilityEvents.APPEARANCE, true)));
                } else if (componentClass == ICharacterSheets.class) {
                    pl.getCapability(CapabilityEvents.PLAYER_CHARACTERS).ifPresent(v -> ModNetworking.syncToClient(pl, new SyncPlayerStatsPacket((Player)pl, CapabilityEvents.CHARACTERS, true)));
                }
            }
        }
    }
}

