/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.forge;

import com.diamssword.characters.forge.CapabilityEvents;
import com.diamssword.characters.forge.SyncedCapability;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.network.NetworkEvent;

public class SyncPlayerStatsPacket {
    private final UUID player;
    private final ResourceLocation capability;
    private final CompoundTag data;

    protected SyncPlayerStatsPacket(UUID player, ResourceLocation capability, CompoundTag data) {
        this.player = player;
        this.capability = capability;
        this.data = data;
    }

    public SyncPlayerStatsPacket(Player player, ResourceLocation capability, boolean toOwner) {
        Capability<?> cap = CapabilityEvents.CAPABILITY_MAP.get(capability);
        Object d = player.getCapability(cap).resolve().get();
        this.player = player.m_20148_();
        this.capability = capability;
        if (d instanceof SyncedCapability) {
            SyncedCapability ca = (SyncedCapability)d;
            this.data = ca.writeSyncData(toOwner);
        } else {
            this.data = new CompoundTag();
        }
    }

    public static void encode(SyncPlayerStatsPacket packet, FriendlyByteBuf buf) {
        buf.m_130077_(packet.player);
        buf.m_130085_(packet.capability);
        buf.m_130079_(packet.data);
    }

    public static SyncPlayerStatsPacket decode(FriendlyByteBuf buf) {
        UUID id = buf.m_130259_();
        ResourceLocation cap = buf.m_130281_();
        CompoundTag data = buf.m_130260_();
        return new SyncPlayerStatsPacket(id, cap, data);
    }

    public static void handle(SyncPlayerStatsPacket packet, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> SyncPlayerStatsPacket.handleClientSide(packet));
        context.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void handleClientSide(SyncPlayerStatsPacket packet) {
        Capability<?> cap;
        Minecraft minecraft = Minecraft.m_91087_();
        ClientLevel level = minecraft.f_91073_;
        if (level == null) {
            return;
        }
        Player player = level.m_46003_(packet.player);
        if (player != null && (cap = CapabilityEvents.CAPABILITY_MAP.get(packet.capability)) != null) {
            player.getCapability(cap).ifPresent(stats -> {
                if (stats instanceof SyncedCapability) {
                    SyncedCapability clientStats = (SyncedCapability)stats;
                    clientStats.applySyncData(packet.data);
                }
            });
        }
    }
}

