/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.mixins;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.IPlayerComponent;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    protected PlayerEntityMixin(EntityType<? extends LivingEntity> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"getDimensions"}, cancellable=true)
    public void getDimensions(Pose pose, CallbackInfoReturnable<EntityDimensions> cir) {
        if (pose == Pose.STANDING || pose == Pose.CROUCHING || pose == Pose.SITTING) {
            IPlayerComponent comp = ComponentManager.getPlayerDatas((Player)this);
            float h = comp.getAppearence().getHeightScale();
            float baseH = pose == Pose.CROUCHING ? 1.5f : 1.8f;
            EntityDimensions dim = EntityDimensions.m_20395_((float)0.6f, (float)(baseH * h));
            cir.setReturnValue((Object)dim);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getActiveEyeHeight"}, cancellable=true)
    public void getActiveEyeHeight(Pose pose, EntityDimensions dimensions, CallbackInfoReturnable<Float> cir) {
        if (pose == Pose.STANDING) {
            cir.setReturnValue((Object)Float.valueOf(dimensions.f_20378_ * 0.9f));
        } else if (pose == Pose.CROUCHING) {
            cir.setReturnValue((Object)Float.valueOf(dimensions.f_20378_ * 0.85f));
        }
    }
}

