/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.network;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.PlayerPresence;
import com.diamssword.characters.network.Channels;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.player.Player;

public class SkinServerCache {
    private final Map<UUID, PlayerInfos> skinCache = new HashMap<UUID, PlayerInfos>();
    protected final Map<UUID, PlayerPresence> existingPlayers = new HashMap<UUID, PlayerPresence>();

    public Optional<PlayerInfos> getSkin(UUID user) {
        return Optional.ofNullable(this.skinCache.get(user));
    }

    public void addToCache(UUID id, String skin, String head, boolean slim) {
        this.skinCache.put(id, new PlayerInfos(skin, head, slim));
    }

    public void removeFromCache(UUID uuid) {
        this.skinCache.remove(uuid);
    }

    public PlayerInfos get(UUID id) {
        return this.skinCache.get(id);
    }

    public static void init() {
        Channels.MAIN.registerClientboundDeferred(SendPlayerInfos.class);
        Channels.MAIN.registerClientboundDeferred(SendPlayerPresences.class);
        Channels.MAIN.registerServerbound(RequestPlayersMatching.class, (msg, ctx) -> Channels.MAIN.serverHandle((Player)ctx.player()).send(new SendPlayerPresences(SkinServerCache.get(ctx.player().f_8924_).getPlayersMatching(msg.query))));
        Channels.MAIN.registerServerbound(RequestPlayerPresence.class, (msg, ctx) -> {
            PlayerPresence dt = SkinServerCache.get((MinecraftServer)ctx.player().f_8924_).existingPlayers.get(msg.player);
            HashMap<UUID, PlayerPresence> m = new HashMap<UUID, PlayerPresence>();
            if (dt != null) {
                m.put(msg.player, dt);
            }
            Channels.MAIN.serverHandle((Player)ctx.player()).send(new SendPlayerPresences(m));
        });
        Channels.MAIN.registerServerbound(RequestPlayerInfos.class, (msg, ctx) -> {
            PlayerInfos skin = SkinServerCache.get((MinecraftServer)ctx.player().f_8924_).skinCache.get(msg.player);
            if (skin != null) {
                Channels.MAIN.serverHandle((Player)ctx.player()).send(new SendPlayerInfos(msg.player, skin.skin, skin.head, skin.slim));
            }
        });
    }

    public void setActiveCharacter(Player player, String characterName, String headTexture) {
        this.existingPlayers.put(player.m_20148_(), new PlayerPresence(characterName, player.m_36316_().getName(), headTexture));
    }

    public Map<UUID, PlayerPresence> getPlayersMatching(String query) {
        String lowerQuery = query.toLowerCase();
        Map<UUID, PlayerPresence> usernameMatches = this.existingPlayers.entrySet().stream().filter(entry -> ((PlayerPresence)entry.getValue()).username().toLowerCase().contains(lowerQuery)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map<UUID, PlayerPresence> characterNameMatches = this.existingPlayers.entrySet().stream().filter(entry -> !usernameMatches.containsKey(entry.getKey())).filter(entry -> ((PlayerPresence)entry.getValue()).characterName().toLowerCase().contains(lowerQuery)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        LinkedHashMap<UUID, PlayerPresence> result = new LinkedHashMap<UUID, PlayerPresence>();
        result.putAll(usernameMatches);
        result.putAll(characterNameMatches);
        return result;
    }

    public static SkinServerCache get(MinecraftServer server) {
        return ComponentManager.INSTANCE.getComponent(server, SkinServerCache.class);
    }

    public record PlayerInfos(String skin, String head, boolean slim) {
    }

    public record SendPlayerInfos(UUID player, String skin, String skinHead, boolean slim) {
    }

    public record SendPlayerPresences(Map<UUID, PlayerPresence> presences) {
    }

    public record RequestPlayersMatching(String query) {
    }

    public record RequestPlayerPresence(UUID player) {
    }

    public record RequestPlayerInfos(UUID player) {
    }
}

