/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.network.owoNetwork.serialization;

import com.diamssword.characters.network.owoNetwork.serialization.RecordSerializer;
import com.diamssword.characters.network.owoNetwork.serialization.SealedPolymorphic;
import com.diamssword.characters.network.owoNetwork.serialization.VectorSerializer;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public record PacketBufSerializer<T>(FriendlyByteBuf.Writer<T> serializer, FriendlyByteBuf.Reader<T> deserializer) {
    private static final Map<Class<?>, Supplier<?>> COLLECTION_PROVIDERS = new HashMap();
    private static final Map<Class<?>, PacketBufSerializer<?>> SERIALIZERS = new HashMap();

    public static <T> void register(Class<T> clazz, PacketBufSerializer<T> serializer) {
        if (SERIALIZERS.containsKey(clazz)) {
            throw new IllegalStateException("Class '" + clazz.getName() + "' already has a serializer");
        }
        SERIALIZERS.put(clazz, serializer);
    }

    public static <T> void register(Class<T> clazz, FriendlyByteBuf.Writer<T> serializer, FriendlyByteBuf.Reader<T> deserializer) {
        PacketBufSerializer.register(clazz, new PacketBufSerializer<T>(serializer, deserializer));
    }

    @SafeVarargs
    private static <T> void register(FriendlyByteBuf.Writer<T> serializer, FriendlyByteBuf.Reader<T> deserializer, Class<T> ... classes) {
        PacketBufSerializer<T> packetSerializer = new PacketBufSerializer<T>(serializer, deserializer);
        for (Class<T> clazz : classes) {
            PacketBufSerializer.register(clazz, packetSerializer);
        }
    }

    public static PacketBufSerializer<?> getGeneric(Type type) {
        if (type instanceof Class) {
            Class klass = (Class)type;
            return PacketBufSerializer.get(klass);
        }
        ParameterizedType pType = (ParameterizedType)type;
        Class raw = (Class)pType.getRawType();
        Type[] typeArgs = pType.getActualTypeArguments();
        if (Map.class.isAssignableFrom(raw)) {
            return PacketBufSerializer.createMapSerializer(PacketBufSerializer.conform(raw, Map.class), (Class)typeArgs[0], (Class)typeArgs[1]);
        }
        if (Collection.class.isAssignableFrom(raw)) {
            return PacketBufSerializer.createCollectionSerializer(PacketBufSerializer.conform(raw, Collection.class), (Class)typeArgs[0]);
        }
        if (Optional.class.isAssignableFrom(raw)) {
            return PacketBufSerializer.createOptionalSerializer((Class)typeArgs[0]);
        }
        return PacketBufSerializer.get(raw);
    }

    public static <T> PacketBufSerializer<T> get(Class<T> clazz) {
        PacketBufSerializer<T> serializer = PacketBufSerializer.getOrNull(clazz);
        if (serializer == null) {
            throw new IllegalStateException("No serializer available for class '" + clazz.getName() + "'");
        }
        return serializer;
    }

    public static <T> Optional<PacketBufSerializer<T>> maybeGet(Class<T> clazz) {
        return Optional.ofNullable(PacketBufSerializer.getOrNull(clazz));
    }

    @Nullable
    private static <T> PacketBufSerializer<T> getOrNull(Class<T> clazz) {
        PacketBufSerializer<Object> serializer = SERIALIZERS.get(clazz);
        if (serializer == null) {
            if (Record.class.isAssignableFrom(clazz)) {
                serializer = PacketBufSerializer.createRecordSerializer(PacketBufSerializer.conform(clazz, Record.class));
            } else if (clazz.isEnum()) {
                serializer = PacketBufSerializer.createEnumSerializer(PacketBufSerializer.conform(clazz, Enum.class));
            } else if (clazz.isArray()) {
                serializer = PacketBufSerializer.createArraySerializer(clazz.getComponentType());
            } else if (clazz.isAnnotationPresent(SealedPolymorphic.class)) {
                serializer = PacketBufSerializer.createSealedSerializer(clazz);
            } else {
                return null;
            }
            SERIALIZERS.put(clazz, serializer);
        }
        return serializer;
    }

    public static <T> void registerCollectionProvider(Class<T> clazz, Supplier<T> provider) {
        if (COLLECTION_PROVIDERS.containsKey(clazz)) {
            throw new IllegalStateException("Collection class '" + clazz.getName() + "' already has a provider");
        }
        COLLECTION_PROVIDERS.put(clazz, provider);
    }

    public static <T> T createCollection(Class<? extends T> clazz) {
        if (!COLLECTION_PROVIDERS.containsKey(clazz)) {
            throw new IllegalStateException("No collection provider registered for collection class " + clazz.getName());
        }
        return (T)COLLECTION_PROVIDERS.get(clazz).get();
    }

    public static <K, V, T extends Map<K, V>> PacketBufSerializer<T> createMapSerializer(Class<T> clazz, Class<K> keyClass, Class<V> valueClass) {
        PacketBufSerializer.createCollection(clazz);
        PacketBufSerializer keySerializer = PacketBufSerializer.get(keyClass);
        PacketBufSerializer valueSerializer = PacketBufSerializer.get(valueClass);
        return new PacketBufSerializer<T>((buf, t) -> buf.m_236831_(t, keySerializer.serializer(), valueSerializer.serializer()), buf -> buf.m_236841_(buf1 -> (Map)PacketBufSerializer.createCollection(clazz), keySerializer.deserializer(), valueSerializer.deserializer()));
    }

    public static <E, T extends Collection<E>> PacketBufSerializer<T> createCollectionSerializer(Class<T> clazz, Class<E> elementClass) {
        PacketBufSerializer.createCollection(clazz);
        PacketBufSerializer elementSerializer = PacketBufSerializer.get(elementClass);
        return new PacketBufSerializer<T>((buf, t) -> buf.m_236828_(t, elementSerializer.serializer()), buf -> buf.m_236838_(value -> (Collection)PacketBufSerializer.createCollection(clazz), elementSerializer.deserializer()));
    }

    public static <E> PacketBufSerializer<Optional<E>> createOptionalSerializer(Class<E> elementClass) {
        PacketBufSerializer elementSerializer = PacketBufSerializer.get(elementClass);
        return new PacketBufSerializer<Optional<E>>((buf, t) -> buf.m_236835_(t, elementSerializer.serializer()), buf -> buf.m_236860_(elementSerializer.deserializer()));
    }

    public static PacketBufSerializer<?> createArraySerializer(Class<?> elementClass) {
        PacketBufSerializer<?> elementSerializer = PacketBufSerializer.get(elementClass);
        return new PacketBufSerializer((buf, t) -> {
            int length = Array.getLength(t);
            buf.m_130130_(length);
            for (int i = 0; i < length; ++i) {
                elementSerializer.serializer().accept(buf, Array.get(t, i));
            }
        }, buf -> {
            int length = buf.m_130242_();
            Object array = Array.newInstance(elementClass, length);
            for (int i = 0; i < length; ++i) {
                Array.set(array, i, elementSerializer.deserializer().apply(buf));
            }
            return array;
        });
    }

    public static <R extends Record> PacketBufSerializer<R> createRecordSerializer(Class<R> clazz) {
        RecordSerializer<R> serializer = RecordSerializer.create(clazz);
        return new PacketBufSerializer(serializer::write, serializer::read);
    }

    public static <E extends Enum<E>> PacketBufSerializer<E> createEnumSerializer(Class<E> enumClass) {
        return new PacketBufSerializer(FriendlyByteBuf::m_130068_, buf -> buf.m_130066_(enumClass));
    }

    public static <T, K> PacketBufSerializer<T> createDispatchedSerializer(Function<K, PacketBufSerializer<? extends T>> keyToSerializer, Function<T, K> keyGetter, PacketBufSerializer<K> keySerializer) {
        return new PacketBufSerializer<T>((buf, value) -> {
            Object key = keyGetter.apply(value);
            PacketBufSerializer serializer = (PacketBufSerializer)keyToSerializer.apply(key);
            keySerializer.serializer.accept(buf, key);
            serializer.serializer.accept(buf, value);
        }, buf -> {
            Object key = keySerializer.deserializer.apply(buf);
            PacketBufSerializer serializer = (PacketBufSerializer)keyToSerializer.apply(key);
            return serializer.deserializer.apply(buf);
        });
    }

    private static PacketBufSerializer<?> createSealedSerializer(Class<?> commonClass) {
        if (!commonClass.isSealed()) {
            throw new IllegalStateException("@SealedPolymorphic class should be sealed!");
        }
        List sortedPermittedSubclasses = Arrays.stream(commonClass.getPermittedSubclasses()).collect(Collectors.toList());
        for (int i = 0; i < sortedPermittedSubclasses.size(); ++i) {
            Class klass = (Class)sortedPermittedSubclasses.get(i);
            if (!klass.isSealed()) continue;
            for (Class<?> subclass : klass.getPermittedSubclasses()) {
                if (sortedPermittedSubclasses.contains(subclass)) continue;
                sortedPermittedSubclasses.add(subclass);
            }
        }
        for (Class klass : sortedPermittedSubclasses) {
            if (klass.isSealed() || Modifier.isFinal(klass.getModifiers())) continue;
            throw new IllegalStateException("Subclasses of a @SealedPolymorphic class must be sealed themselves!");
        }
        sortedPermittedSubclasses.sort(Comparator.comparing(Class::getName));
        Int2ObjectOpenHashMap serializerMap = new Int2ObjectOpenHashMap();
        Reference2IntOpenHashMap classesMap = new Reference2IntOpenHashMap();
        classesMap.defaultReturnValue(-1);
        for (int i = 0; i < sortedPermittedSubclasses.size(); ++i) {
            Class klass = (Class)sortedPermittedSubclasses.get(i);
            serializerMap.put(i, PacketBufSerializer.get(klass));
            classesMap.put((Object)klass, i);
        }
        return new PacketBufSerializer((arg_0, arg_1) -> PacketBufSerializer.lambda$createSealedSerializer$13((Reference2IntMap)classesMap, commonClass, (Int2ObjectMap)serializerMap, arg_0, arg_1), arg_0 -> PacketBufSerializer.lambda$createSealedSerializer$14((Int2ObjectMap)serializerMap, arg_0));
    }

    private static <T> Class<T> conform(Class<?> clazz, Class<T> target) {
        return clazz;
    }

    private static /* synthetic */ Object lambda$createSealedSerializer$14(Int2ObjectMap serializerMap, FriendlyByteBuf buf) {
        int idx = buf.m_130242_();
        PacketBufSerializer serializer = (PacketBufSerializer)serializerMap.get(idx);
        if (serializer == null) {
            throw new IllegalStateException("Unknown index " + idx);
        }
        return serializer.deserializer.apply((Object)buf);
    }

    private static /* synthetic */ void lambda$createSealedSerializer$13(Reference2IntMap classesMap, Class commonClass, Int2ObjectMap serializerMap, FriendlyByteBuf buf, Object value) {
        int idx = classesMap.getInt(value.getClass());
        if (idx == -1) {
            throw new IllegalStateException("Tried to serialize instance of " + value.getClass() + " as a " + commonClass);
        }
        buf.m_130130_(idx);
        ((PacketBufSerializer)serializerMap.get((int)idx)).serializer.accept(buf, value);
    }

    static {
        PacketBufSerializer.register(FriendlyByteBuf::writeBoolean, FriendlyByteBuf::readBoolean, Boolean.class, Boolean.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::m_130130_, FriendlyByteBuf::m_130242_, Integer.class, Integer.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::m_130103_, FriendlyByteBuf::m_130258_, Long.class, Long.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::writeFloat, FriendlyByteBuf::readFloat, Float.class, Float.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::writeDouble, FriendlyByteBuf::readDouble, Double.class, Double.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::writeByte, FriendlyByteBuf::readByte, Byte.class, Byte.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::writeShort, FriendlyByteBuf::readShort, Short.class, Short.TYPE);
        PacketBufSerializer.register(FriendlyByteBuf::writeChar, FriendlyByteBuf::readChar, Character.class, Character.TYPE);
        PacketBufSerializer.register(Void.class, (packetByteBuf, unused) -> {}, packetByteBuf -> null);
        PacketBufSerializer.register(String.class, FriendlyByteBuf::m_130070_, FriendlyByteBuf::m_130277_);
        PacketBufSerializer.register(UUID.class, FriendlyByteBuf::m_130077_, FriendlyByteBuf::m_130259_);
        PacketBufSerializer.register(Date.class, FriendlyByteBuf::m_130075_, FriendlyByteBuf::m_130282_);
        PacketBufSerializer.register(FriendlyByteBuf.class, (buf, other) -> {
            buf.m_130130_(other.readableBytes());
            buf.writeBytes((ByteBuf)other);
        }, buf -> new FriendlyByteBuf(buf.readBytes(buf.m_130242_())));
        PacketBufSerializer.register(BlockPos.class, FriendlyByteBuf::m_130064_, FriendlyByteBuf::m_130135_);
        PacketBufSerializer.register(ChunkPos.class, FriendlyByteBuf::m_178341_, FriendlyByteBuf::m_178383_);
        PacketBufSerializer.register(ItemStack.class, FriendlyByteBuf::m_130055_, FriendlyByteBuf::m_130267_);
        PacketBufSerializer.register(ResourceLocation.class, FriendlyByteBuf::m_130085_, FriendlyByteBuf::m_130281_);
        PacketBufSerializer.register(CompoundTag.class, FriendlyByteBuf::m_130079_, FriendlyByteBuf::m_130260_);
        PacketBufSerializer.register(BlockHitResult.class, FriendlyByteBuf::m_130062_, FriendlyByteBuf::m_130283_);
        PacketBufSerializer.register(BitSet.class, FriendlyByteBuf::m_178350_, FriendlyByteBuf::m_178384_);
        PacketBufSerializer.register(Component.class, FriendlyByteBuf::m_130083_, FriendlyByteBuf::m_130238_);
        PacketBufSerializer.register(ParticleOptions.class, (buf, particleEffect) -> {
            buf.writeInt(BuiltInRegistries.f_257034_.m_7447_((Object)particleEffect.m_6012_()));
            particleEffect.m_7711_(buf);
        }, buf -> {
            ParticleType particleType = (ParticleType)BuiltInRegistries.f_257034_.m_7942_(buf.readInt());
            return particleType.m_123743_().m_6507_(particleType, buf);
        });
        PacketBufSerializer.register(Vec3.class, VectorSerializer::write, VectorSerializer::read);
        PacketBufSerializer.register(Vector3f.class, VectorSerializer::writef, VectorSerializer::readf);
        PacketBufSerializer.registerCollectionProvider(Collection.class, HashSet::new);
        PacketBufSerializer.registerCollectionProvider(List.class, ArrayList::new);
        PacketBufSerializer.registerCollectionProvider(Map.class, LinkedHashMap::new);
    }
}

