/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.api.http.ApiSkinValues;
import com.diamssword.characters.storage.ClothingLoader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class PlayerAppearance
implements IPlayerAppearance {
    private float scaledHeight = 1.0f;
    private final Map<String, Cloth> cloths = new HashMap<String, Cloth>();
    private final Player parent;
    private final List<String> unlockedCloths = new ArrayList<String>();
    private final SavedOutfit[] outfits = new SavedOutfit[7];
    private ApiSkinValues skinDatas;

    public PlayerAppearance(Player parent) {
        this.parent = parent;
        if (!parent.m_9236_().f_46443_ && parent.m_36316_() != null) {
            this.refreshSkinData();
        }
    }

    public void tick() {
        if (this.skinDatas == null && !this.parent.m_9236_().f_46443_ && this.parent.f_19797_ % 20 == 0 && this.parent.m_36316_() != null) {
            this.refreshSkinData();
        }
    }

    public ApiSkinValues getSkinDatas() {
        return this.skinDatas;
    }

    public void refreshSkinData() {
        ICharacterSheets carM = ComponentManager.getPlayerCharacter(this.parent);
        if (carM != null && carM.getCurrentCharacter() != null) {
            this.skinDatas = carM.getCurrentCharacter().appearance;
            if (this.skinDatas != null) {
                this.scaledHeight = ApiSkinValues.HeightMToMCScale(1, this.skinDatas.size);
                ComponentManager.syncPlayerDatas(this.parent);
            }
        }
    }

    @Override
    public void clonePlayerAppearance(Player sourcePlayer) {
        IPlayerAppearance car = ComponentManager.getPlayerDatas(sourcePlayer).getAppearence();
        if (car != null) {
            CompoundTag tag = new CompoundTag();
            car.writeToNbt(tag, 0);
            this.readFromNbt(tag);
        }
    }

    @Override
    public void unlockCloth(Cloth cloth) {
        if (!this.unlockedCloths.contains(cloth.layer().id + "_" + cloth.id())) {
            this.unlockedCloths.add(cloth.layer().id + "_" + cloth.id());
        }
    }

    @Override
    public void lockCLoth(Cloth cloth) {
        this.unlockedCloths.remove(cloth.layer().id + "_" + cloth.id());
    }

    @Override
    public ArrayList<String> getUnlockedCloths() {
        return new ArrayList<String>(this.unlockedCloths);
    }

    @Override
    public Optional<Cloth> getEquippedCloth(LayerDef layer) {
        return Optional.ofNullable(this.cloths.get(layer.getId()));
    }

    @Override
    public Map<String, Cloth> getEquippedCloths() {
        HashMap<String, Cloth> res = new HashMap<String, Cloth>(this.cloths);
        for (LayerDef layer : ClothingLoader.instance.getClothLayers()) {
            if (res.containsKey(layer.getId())) continue;
            res.put(layer.getId(), null);
        }
        return res;
    }

    @Override
    public Map<String, Cloth> getEquippedLayers() {
        HashMap<String, Cloth> res = new HashMap<String, Cloth>(this.cloths);
        for (LayerDef layer : ClothingLoader.instance.getLayers().values()) {
            if (res.containsKey(layer.getId())) continue;
            res.put(layer.getId(), null);
        }
        return res;
    }

    private void fillForcedLayers() {
        ClothingLoader.instance.getLayers().values().stream().filter(LayerDef::isForced).forEach(la -> {
            List<Cloth> l;
            Optional<Cloth> und = this.getEquippedCloth((LayerDef)la);
            if (und.isEmpty() && !(l = ClothingLoader.instance.getForLayers((LayerDef)la)).isEmpty()) {
                this.setCloth(l.get(0));
            }
        });
    }

    public Optional<ClothData> getClothDatas(LayerDef layer) {
        return this.getEquippedCloth(layer).map(v -> new ClothData(v.id(), false, -1));
    }

    @Override
    public boolean equipCloth(Cloth cloth) {
        if (cloth == null) {
            return false;
        }
        if (this.parent.m_9236_().f_46443_ || this.parent.m_7500_() || this.unlockedCloths.contains(cloth.layer().getId() + "_" + cloth.id())) {
            this.setCloth(cloth.layer().id, cloth);
            return true;
        }
        return false;
    }

    @Override
    public void setCloth(String layer, @Nullable Cloth cloth) {
        if (cloth == null) {
            ClothingLoader.instance.getLayer(layer).ifPresent(l -> {
                if (!l.isForced()) {
                    this.cloths.remove(layer);
                }
            });
        } else {
            this.cloths.put(layer, cloth);
        }
        if (this.parent instanceof ServerPlayer) {
            ComponentManager.syncPlayerDatas(this.parent);
        }
    }

    @Override
    public void setCloth(Cloth cloth) {
        if (cloth != null) {
            this.setCloth(cloth.layer().getId(), cloth);
        }
    }

    @Override
    public void removeCloth(String layer) {
        this.setCloth(layer, null);
    }

    @Override
    public void saveOutfit(String name, int index) {
        if (index < this.outfits.length && index >= 0) {
            this.outfits[index] = new SavedOutfit(name, this);
            this.outfits[index].populate();
        }
    }

    @Override
    public List<Tuple<String, Integer>> getOutfits() {
        ArrayList<Tuple<String, Integer>> res = new ArrayList<Tuple<String, Integer>>();
        for (int i = 0; i < this.outfits.length; ++i) {
            if (this.outfits[i] == null) continue;
            res.add((Tuple<String, Integer>)new Tuple((Object)this.outfits[i].name, (Object)i));
        }
        return res;
    }

    @Override
    public void equipOutfit(int index) {
        if (index < this.outfits.length && index >= 0 && this.outfits[index] != null) {
            this.outfits[index].equipe();
        }
    }

    @Override
    public float getHeightScale() {
        return Math.max(0.8f, Math.min(1.1f, this.scaledHeight));
    }

    @Override
    public void readFromNbt(CompoundTag tag) {
        CompoundTag cl;
        if (tag.m_128441_("default")) {
            this.skinDatas = new ApiSkinValues().fromNBT(tag.m_128469_("default"));
            this.scaledHeight = ApiSkinValues.HeightMToMCScale(1, this.skinDatas.size);
        }
        if (tag.m_128441_("cloths")) {
            this.cloths.clear();
            cl = tag.m_128469_("cloths");
            cl.m_128431_().forEach(k -> {
                try {
                    Optional<Cloth> cl1 = ClothingLoader.instance.getCloth(cl.m_128461_(k));
                    cl1.ifPresent(v -> this.cloths.put(v.layer().getId(), (Cloth)v));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
        if (tag.m_128441_("unlockedCloths")) {
            this.unlockedCloths.clear();
            cl = tag.m_128437_("unlockedCloths", 10);
            cl.forEach(k -> this.unlockedCloths.add(((CompoundTag)k).m_128461_("id")));
        }
        if (tag.m_128441_("outfits")) {
            cl = tag.m_128437_("outfits", 10);
            for (int i = 0; i < cl.size(); ++i) {
                if (i >= this.outfits.length) continue;
                this.outfits[i] = ((CompoundTag)cl.get(i)).m_128456_() ? null : new SavedOutfit("", this).fromNBT((CompoundTag)cl.get(i));
            }
        }
        this.fillForcedLayers();
    }

    @Override
    public CompoundTag writeToNbt(CompoundTag tag, int mode) {
        if (this.skinDatas != null && mode == 1) {
            tag.m_128365_("default", (Tag)this.skinDatas.toNBT());
        }
        CompoundTag cloths = new CompoundTag();
        ListTag unlocked = new ListTag();
        this.unlockedCloths.forEach(v -> {
            CompoundTag t = new CompoundTag();
            t.m_128359_("id", v);
            unlocked.add((Object)t);
        });
        this.cloths.forEach((i, v) -> cloths.m_128359_(i, v.layer().getId() + "_" + v.id()));
        tag.m_128365_("unlockedCloths", (Tag)unlocked);
        tag.m_128365_("cloths", (Tag)cloths);
        ListTag outLs = new ListTag();
        for (SavedOutfit outfit : this.outfits) {
            if (outfit != null) {
                outLs.add((Object)outfit.toNBT());
                continue;
            }
            outLs.add((Object)new CompoundTag());
        }
        tag.m_128365_("outfits", (Tag)outLs);
        return tag;
    }

    @Override
    public void onCharacterLoad(Player player, String newCharacterID, ApiCharacterValues newCharacter, @Nullable String oldCharacterID) {
        this.refreshSkinData();
    }

    public static CompoundTag serializer(IPlayerAppearance instance) {
        CompoundTag res = new CompoundTag();
        instance.writeToNbt(res, 0);
        return res;
    }

    public static void unserializer(IPlayerAppearance instance, CompoundTag tag) {
        instance.readFromNbt(tag);
    }

    public static class SavedOutfit {
        public List<String> cloths = new ArrayList<String>();
        public String name;
        public final PlayerAppearance parent;

        public SavedOutfit(String name, PlayerAppearance parent) {
            this.name = name;
            this.parent = parent;
        }

        public void populate() {
            this.cloths.clear();
            this.parent.getEquippedCloths().forEach((l, c) -> {
                if (c != null) {
                    this.cloths.add(c.layer().getId() + "_" + c.id());
                }
            });
        }

        public SavedOutfit fromNBT(CompoundTag tag) {
            this.name = tag.m_128461_("name");
            ListTag ls = tag.m_128437_("cloths", 10);
            ls.forEach(v -> this.cloths.add(((CompoundTag)v).m_128461_("id")));
            return this;
        }

        public CompoundTag toNBT() {
            CompoundTag res = new CompoundTag();
            res.m_128359_("name", this.name);
            ListTag ls = new ListTag();
            this.cloths.forEach(c -> {
                CompoundTag c1 = new CompoundTag();
                c1.m_128359_("id", c);
                ls.add((Object)c1);
            });
            res.m_128365_("cloths", (Tag)ls);
            return res;
        }

        public void equipe() {
            this.cloths.forEach(v -> ClothingLoader.instance.getCloth((String)v).ifPresent(this.parent::equipCloth));
        }
    }

    public record ClothData(String texture, boolean needColor, int color) {
    }
}

