/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.ICharacterSheets;
import com.diamssword.characters.api.ICharacterStored;
import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.network.SkinServerCache;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PlayerCharacters
implements ICharacterSheets {
    private static final Map<ResourceLocation, StorageGlobal> globalRegister = new HashMap<ResourceLocation, StorageGlobal>();
    protected final Player player;
    protected final Map<ResourceLocation, Storage> registered = new HashMap<ResourceLocation, Storage>();
    protected final Map<String, ApiCharacterValues> characters = new HashMap<String, ApiCharacterValues>();
    protected final Map<String, CompoundTag> storedDatas = new HashMap<String, CompoundTag>();
    protected String currentCharID;
    protected ApiCharacterValues currentCharacter;

    public PlayerCharacters(Player e) {
        this.player = e;
        if (e instanceof ServerPlayer) {
            ServerPlayer pl = (ServerPlayer)e;
            globalRegister.forEach((k, v) -> this.attachComponent((ResourceLocation)k, () -> v.provider.apply(pl), () -> v.serializer.apply(v.provider.apply(pl)), t -> v.unserializer.accept(v.provider.apply(pl), (CompoundTag)t)));
        }
    }

    @Override
    public Set<String> getCharactersNames() {
        return this.characters.keySet();
    }

    @Override
    public ApiCharacterValues getCurrentCharacter() {
        return this.currentCharacter;
    }

    @Override
    public String getCurrentCharacterID() {
        return this.currentCharID;
    }

    @Override
    public void switchCharacter(String id) {
        ApiCharacterValues car = this.characters.get(id);
        String oldChar = this.currentCharID;
        if (car != null) {
            this.currentCharacter = car;
            this.currentCharID = id;
            CompoundTag oldCharSave = new CompoundTag();
            CompoundTag newStore = this.storedDatas.getOrDefault(id, new CompoundTag());
            this.registered.forEach((i, s) -> {
                if (oldChar != null) {
                    oldCharSave.m_128365_(i.toString(), (Tag)s.serializer.get());
                }
                if (newStore.m_128441_(i.toString())) {
                    s.unserializer.accept(newStore.m_128469_(i.toString()));
                }
                s.instance.get().onCharacterLoad(this.player, id, car, oldChar);
            });
            if (oldChar != null) {
                this.storedDatas.put(oldChar, oldCharSave);
            }
            SkinServerCache.get(this.player.m_20194_()).addToCache(this.player.m_20148_(), car.base64Skin, car.base64SkinHead, car.appearance.slim);
            ComponentManager.syncPlayerCharacter(this.player);
            SkinServerCache.get(this.player.m_20194_()).setActiveCharacter(this.player, this.currentCharacter.stats.firstname + " " + this.currentCharacter.stats.lastname, this.currentCharacter.base64SkinHead);
        }
    }

    @Override
    public void deleteCharacter(String id) {
        this.characters.remove(id);
        this.storedDatas.remove(id);
        if (id.equals(this.currentCharID)) {
            this.currentCharID = null;
        }
    }

    @Override
    public String addNewCharacter(ApiCharacterValues character) {
        String id = character.stats.firstname.toLowerCase().replaceAll(" ", "") + "_" + character.stats.lastname.toLowerCase().replaceAll(" ", "");
        int i = 1;
        String itid = id;
        while (this.characters.containsKey(itid)) {
            itid = id + i;
            ++i;
        }
        this.characters.put(itid, character);
        return itid;
    }

    @Override
    public void replaceCharacter(String id, ApiCharacterValues character) {
        this.characters.put(id, character);
        this.storedDatas.remove(id);
    }

    @Override
    public void attachComponent(ResourceLocation id, Supplier<ICharacterStored> instance, Supplier<CompoundTag> serializer, Consumer<CompoundTag> unserializer) {
        this.registered.put(id, new Storage(instance, serializer, unserializer));
    }

    @Override
    public void unattachComponent(ResourceLocation id) {
        this.registered.remove(id);
    }

    public static <T extends ICharacterStored> void attachComponentToCharacters(ResourceLocation id, Function<ServerPlayer, T> provider, Function<T, CompoundTag> serializer, BiConsumer<T, CompoundTag> unserializer) {
        globalRegister.put(id, new StorageGlobal(provider, serializer, unserializer));
        Characters.LOGGER.info("Attached Character Sheet Component: {}", (Object)id);
    }

    public static void unattachComponentFromCharacters(ResourceLocation id) {
        globalRegister.remove(id);
    }

    protected record Storage(Supplier<ICharacterStored> instance, Supplier<CompoundTag> serializer, Consumer<CompoundTag> unserializer) {
    }

    protected record StorageGlobal(Function<ServerPlayer, ICharacterStored> provider, Function<ICharacterStored, CompoundTag> serializer, BiConsumer<ICharacterStored, CompoundTag> unserializer) {
    }
}

