/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.api.http.ApiCharacterValues;
import com.diamssword.characters.api.stats.IPlayerStats;
import com.diamssword.characters.api.stats.StatsRole;
import com.diamssword.characters.storage.ClassesLoader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.Nullable;

public class PlayerStats
implements IPlayerStats {
    private final Map<String, Integer> stats = new HashMap<String, Integer>();
    private final Map<String, Integer> storedXP = new HashMap<String, Integer>();
    public final Player player;

    public PlayerStats(Player parent) {
        this.player = parent;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        CompoundTag st = nbt.m_128469_("stats");
        Map<String, StatsRole> ls = ClassesLoader.getRoles();
        st.m_128431_().forEach(k -> {
            if (ls.containsKey(k)) {
                this.stats.put((String)k, st.m_128451_(k));
            }
        });
        CompoundTag xps = nbt.m_128469_("xp");
        xps.m_128431_().forEach(k -> {
            try {
                if (ls.containsKey(k)) {
                    this.storedXP.put((String)k, xps.m_128451_(k));
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        if (!this.player.m_9236_().f_46443_) {
            this.onPlayerRespawn();
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag nbt = new CompoundTag();
        CompoundTag nbt2 = new CompoundTag();
        CompoundTag nbt1 = new CompoundTag();
        this.stats.forEach((arg_0, arg_1) -> ((CompoundTag)nbt1).m_128405_(arg_0, arg_1));
        this.storedXP.forEach((arg_0, arg_1) -> ((CompoundTag)nbt2).m_128405_(arg_0, arg_1));
        nbt.m_128365_("stats", (Tag)nbt1);
        nbt.m_128365_("xp", (Tag)nbt2);
        return nbt;
    }

    @Override
    public int getLevel(String main) {
        return this.stats.getOrDefault(main, 0);
    }

    @Override
    public int getPalier(String main) {
        Integer v = this.stats.getOrDefault(main, 0);
        Optional<StatsRole> c = ClassesLoader.getRole(main);
        return c.map(statsRole -> statsRole.getPalierForLevel(v)).orElse(0);
    }

    @Override
    public int getXp(String role) {
        return this.storedXP.getOrDefault(role, 0);
    }

    @Override
    public void setLevel(String role, int count) {
        this.stats.put(role, count);
        ClassesLoader.onLevelChange(this.player, role, count);
    }

    @Override
    public void setXp(String role, int count) {
        int l = this.getLevel(role);
        int nex = ClassesLoader.instance.getXpCostForLevel(l + 1);
        if (nex > 0 && count >= nex) {
            this.setLevel(role, l + 1);
            count -= nex;
        }
        this.storedXP.put(role, count);
    }

    @Override
    public int getOrCreate(String main, int level) {
        if (!this.stats.containsKey(main)) {
            this.stats.put(main, level);
        }
        return this.stats.get(main);
    }

    public void onPlayerRespawn() {
        for (Map.Entry<String, Integer> item : this.stats.entrySet()) {
            ClassesLoader.onLevelChange(this.player, item.getKey(), item.getValue());
        }
    }

    @Override
    public void onCharacterLoad(Player player, String newCharacterID, ApiCharacterValues newCharacter, @Nullable String oldCharacterID) {
    }

    public static CompoundTag serializer(IPlayerStats instance) {
        return instance.writeToNbt();
    }

    public static void unserializer(IPlayerStats instance, CompoundTag tag) {
        instance.readFromNbt(tag);
    }
}

