/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters;

import com.diamssword.characters.Events;
import com.diamssword.characters.InventorySaver;
import com.diamssword.characters.api.CharactersApi;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.client.ClientComesticsPacket;
import com.diamssword.characters.client.Entities;
import com.diamssword.characters.commands.ClothCommand;
import com.diamssword.characters.commands.PStatsCommand;
import com.diamssword.characters.commands.SkinCommand;
import com.diamssword.characters.commands.WardrobeCommand;
import com.diamssword.characters.config.Config;
import com.diamssword.characters.config.ConfigManager;
import com.diamssword.characters.implementations.CharactersApiImpl;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.storage.ClassesLoader;
import com.diamssword.characters.storage.ClothingLoader;
import com.diamssword.characters.storage.PlayerAppearance;
import com.diamssword.characters.storage.PlayerCharacters;
import com.diamssword.characters.storage.PlayerStats;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.platform.Platform;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.Env;
import java.util.function.Consumer;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class Characters {
    public static final String MOD_ID = "character_sheet";
    public static final Logger LOGGER = LogManager.getLogger((String)"character_sheet");
    public static Config config;

    public static void init() {
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)ClothingLoader.instance, (ResourceLocation)ClothingLoader.instance.getId());
        ReloadListenerRegistry.register((PackType)PackType.SERVER_DATA, (PreparableReloadListener)ClassesLoader.instance, (ResourceLocation)ClassesLoader.instance.getId());
        ClassesLoader.initEvents();
        CharactersApi.instance = new CharactersApiImpl();
        PlayerCharacters.attachComponentToCharacters(CharactersApi.CHARACTER_ATTACHED_COMPONENT_APPEARANCE, p -> ComponentManager.getPlayerDatas((Player)p).getAppearence(), PlayerAppearance::serializer, PlayerAppearance::unserializer);
        PlayerCharacters.attachComponentToCharacters(CharactersApi.CHARACTER_ATTACHED_COMPONENT_INVENTORY, InventorySaver::new, InventorySaver::serializer, InventorySaver::unserializer);
        PlayerCharacters.attachComponentToCharacters(CharactersApi.CHARACTER_ATTACHED_COMPONENT_STATS, p -> ComponentManager.getPlayerDatas((Player)p).getStats(), PlayerStats::serializer, PlayerStats::unserializer);
        config = ConfigManager.loadConfig();
        Channels.init();
        Events.init();
        if (Platform.getEnvironment() == Env.CLIENT) {
            Characters.initClient();
        }
        Characters.registerCommand("character", SkinCommand::register);
        Characters.registerCommand("cloths", ClothCommand::register);
        Characters.registerCommand("playerskills", PStatsCommand::register);
        Characters.registerCommand("wardrobe", WardrobeCommand::register);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void initClient() {
        ClientComesticsPacket.init();
        Entities.init();
    }

    public static ResourceLocation asRessource(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public static void registerCommand(String name, Consumer<LiteralArgumentBuilder<CommandSourceStack>> builder) {
        LiteralArgumentBuilder l = Commands.m_82127_((String)name);
        builder.accept((LiteralArgumentBuilder<CommandSourceStack>)l);
        CommandRegistrationEvent.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(l));
    }
}

