/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.api.stats;

import com.diamssword.characters.api.stats.StatsRolePalier;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;

public abstract class StatsRole {
    public final String name;
    public final String id;
    public final int[] stages;
    protected Map<Integer, StatsRolePalier> map = new TreeMap<Integer, StatsRolePalier>();
    protected Map<Attribute, Function<Integer, AttributeModifier>> globalModifiers = new HashMap<Attribute, Function<Integer, AttributeModifier>>();

    public StatsRole(String id, JsonObject data) {
        this.id = id;
        int[] p = new int[]{};
        if (data.has("stages")) {
            p = data.get("stages").getAsJsonArray().asList().stream().map(JsonElement::getAsInt).mapToInt(Integer::intValue).toArray();
        }
        this.name = data.get("name").getAsString();
        this.stages = p;
    }

    public abstract void init();

    public int create(int level, Consumer<StatsRolePalier> init) {
        StatsRolePalier c = new StatsRolePalier(this, level);
        this.map.put(level, c);
        init.accept(c);
        return level;
    }

    public StatsRolePalier getPalierInfos(int palier) {
        return this.map.get(palier);
    }

    public int getPalierForLevel(int level) {
        int d = 0;
        for (int i = 0; i < this.stages.length; ++i) {
            if (this.stages[i] > level) {
                return d;
            }
            d = i + 1;
        }
        return d;
    }

    public void addGlobalModifier(Attribute attr, Function<Integer, AttributeModifier> modifier) {
        this.globalModifiers.put(attr, modifier);
    }

    public Map<Attribute, Function<Integer, AttributeModifier>> getGlobalModifiers() {
        return this.globalModifiers;
    }

    public void onLevelChange(Player pl, int level) {
        this.changeModifiers(pl, level);
    }

    private void changeModifiers(Player pl, int level) {
        for (Map.Entry<Integer, StatsRolePalier> entry : this.map.entrySet()) {
            entry.getValue().clearModifier(pl);
        }
        for (Map.Entry<Integer, Object> entry : this.globalModifiers.entrySet()) {
            AttributeInstance max = pl.m_21051_((Attribute)entry.getKey());
            AttributeModifier r = (AttributeModifier)((Function)entry.getValue()).apply(level);
            max.m_22127_(r.m_22209_());
            max.m_22125_(r);
        }
        for (int last = this.getPalierForLevel(level); last > 0; --last) {
            StatsRolePalier statsRolePalier = this.map.get(last);
            if (statsRolePalier == null) {
                continue;
            }
            statsRolePalier.changeModifiers(pl);
            break;
        }
    }
}

