/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client.gui;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.IPlayerComponent;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.client.gui.OutfitPopupGui;
import com.diamssword.characters.client.gui.components.BaseComponent;
import com.diamssword.characters.client.gui.components.CategoryButton;
import com.diamssword.characters.client.gui.components.ClothButtonComponent;
import com.diamssword.characters.client.gui.components.PlayerComponent;
import com.diamssword.characters.client.gui.components.ScrollableCloths;
import com.diamssword.characters.client.gui.components.Sizing;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.CosmeticsPackets;
import com.diamssword.characters.storage.ClothingLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;

public class WardrobeGui
extends Screen {
    private final List<BaseComponent> components = new ArrayList<BaseComponent>();
    private final List<Tuple<String, LayerDef[]>> layerBts = new ArrayList<Tuple<String, LayerDef[]>>();
    private Tuple<String, LayerDef[]> currentLayer;
    private Map<String, Cloth> oldCloths;
    private String lastSearch = "";
    private final boolean shouldShowOutifits;
    private final Function<Player, Map<String, Cloth>> equippedProvider;

    public WardrobeGui(String type) {
        super((Component)Component.m_237113_((String)""));
        List<LayerDef> layers;
        if (type == null || type.equals("default")) {
            this.shouldShowOutifits = true;
            layers = ClothingLoader.instance.getClothLayers();
            this.layerBts.add((Tuple<String, LayerDef[]>)new Tuple((Object)"all", (Object)layers.toArray(new LayerDef[0])));
            this.layerBts.add((Tuple<String, LayerDef[]>)new Tuple((Object)"current", (Object)layers.toArray(new LayerDef[0])));
            this.equippedProvider = p -> ComponentManager.getPlayerDatas(p).getAppearence().getEquippedCloths();
        } else {
            this.shouldShowOutifits = false;
            layers = ClothingLoader.instance.getLayers().values().stream().filter(v -> type.equals(v.getSpecialEditor())).toList();
            this.equippedProvider = p -> ComponentManager.getPlayerDatas(p).getAppearence().getEquippedLayers();
        }
        for (LayerDef l : layers) {
            this.layerBts.add((Tuple<String, LayerDef[]>)new Tuple((Object)l.getId(), (Object)new LayerDef[]{l}));
        }
        this.currentLayer = this.layerBts.get(0);
    }

    public <T extends BaseComponent> T addComponent(T comp) {
        this.components.add(comp);
        this.m_169394_(comp);
        return comp;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.components.clear();
        final PlayerComponent playerComp = this.addComponent(new PlayerComponent(Sizing.fill(40), Sizing.content(0))).scaleToFit(true).lookAtCursor(true);
        int rightX = (int)((float)this.f_96543_ * 0.55f);
        int rightW = (int)((float)this.f_96543_ * 0.4f);
        final ScrollableCloths scroll = (ScrollableCloths)this.m_142416_((GuiEventListener)new ScrollableCloths(rightX, (int)((float)this.f_96544_ * 0.2f), rightW, (int)((float)this.f_96544_ * 0.7f)));
        EditBox search = new EditBox(this.f_96541_.f_91062_, rightX, (int)((float)this.f_96544_ * 0.2f) - 20, rightW, 18, (Component)Component.m_237115_((String)"character_sheet.wardrobe.search"));
        AbstractSliderButton slider = new AbstractSliderButton(0, 0, 0, 20, (Component)Component.m_237113_((String)"0\u00b0"), 0.5){

            protected void m_5695_() {
                int v = (int)(-180.0 + this.f_93577_ * 360.0);
                this.m_93666_((Component)Component.m_237113_((String)(v + "\u00b0")));
            }

            protected void m_5697_() {
                playerComp.rotation((int)(-180.0 + this.f_93577_ * 360.0));
            }
        };
        search.m_257771_((Component)Component.m_237115_((String)"character_sheet.wardrobe.search"));
        this.m_7787_((GuiEventListener)slider);
        this.m_169394_((Renderable)slider);
        this.m_7787_((GuiEventListener)search);
        this.m_169394_((Renderable)search);
        this.components.forEach(c -> c.mount(0, 0, this.f_96543_, this.f_96544_));
        playerComp.x = (int)((float)this.f_96543_ * 0.15f);
        playerComp.y = this.f_96544_ / 2 - playerComp.height / 2;
        slider.m_252865_(playerComp.x + 20);
        slider.m_93674_(playerComp.width - 40);
        slider.m_253211_(playerComp.y + playerComp.height + 5);
        Player player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas(player);
        dt.getAppearence().clonePlayerAppearance((Player)Minecraft.m_91087_().f_91074_);
        this.loadCloths(scroll, playerComp, "");
        search.m_94151_(v -> this.loadCloths(scroll, playerComp, v.toLowerCase()));
        this.m_7522_((GuiEventListener)search);
        if (this.shouldShowOutifits) {
            List<Tuple<String, Integer>> outfits = dt.getAppearence().getOutfits();
            int mid = (int)((float)this.f_96544_ * 0.2f - 20.0f);
            for (int i = 1; i <= 7; ++i) {
                MutableComponent v2 = Component.m_237110_((String)"character_sheet.wardrobe.outfitbt", (Object[])new Object[]{i});
                int i1 = i - 1;
                if (i1 < outfits.size()) {
                    v2 = Component.m_237113_((String)((String)outfits.get(i1).m_14418_()));
                }
                Button bt = new Button.Builder((Component)v2.m_6881_(), a -> {
                    if (Screen.m_96638_()) {
                        this.createOutfitWindow(a, i1);
                    } else {
                        Channels.MAIN.clientHandle().send(new CosmeticsPackets.EquipOutfit(i1));
                        dt.getAppearence().equipOutfit(i1);
                        this.loadCloths(scroll, playerComp, this.lastSearch);
                    }
                }).m_252794_(5, mid + 22 * (i - 1)).m_253046_((int)((float)this.f_96543_ * 0.2f), 20).m_257505_(Tooltip.m_257550_((Component)v2.m_7220_((Component)Component.m_237115_((String)"character_sheet.wardrobe.outfitbt.tooltip").m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})))).m_253136_();
                this.m_142416_((GuiEventListener)bt);
                this.m_7787_((GuiEventListener)bt);
            }
        }
        final ArrayList<CategoryButton> bts = new ArrayList<CategoryButton>();
        for (int i = 0; i < this.layerBts.size(); ++i) {
            final Tuple<String, LayerDef[]> value = this.layerBts.get(i);
            CategoryButton bt = new CategoryButton((Component)Component.m_237119_(), Characters.asRessource("textures/gui/icons/" + (String)value.m_14418_() + ".png"), new Button.OnPress(){

                public void m_93750_(Button button) {
                    for (CategoryButton d : bts) {
                        d.setActivated(false);
                    }
                    if (button instanceof CategoryButton) {
                        CategoryButton oc = (CategoryButton)button;
                        oc.setActivated(true);
                    }
                    WardrobeGui.this.currentLayer = value;
                    WardrobeGui.this.loadCloths(scroll, playerComp, WardrobeGui.this.lastSearch);
                }
            });
            bt.m_252865_((int)((float)this.f_96543_ * 0.45f + (float)(i % 2 == 0 ? 0 : 22)));
            bt.m_253211_(50 + 22 * (i / 2));
            bt.m_257544_(Tooltip.m_257550_((Component)Component.m_237115_((String)("character_sheet.wardrobe.layerbt." + (String)value.m_14418_()))));
            if (((String)value.m_14418_()).equals("all")) {
                bt.setActivated(true);
            }
            this.m_7787_((GuiEventListener)bt);
            this.m_169394_((Renderable)bt);
            bts.add(bt);
        }
    }

    private void loadCloths(ScrollableCloths layout, PlayerComponent playerComp, String filter) {
        this.lastSearch = filter;
        Player player = playerComp.entity();
        IPlayerComponent dt = ComponentManager.getPlayerDatas(player);
        this.oldCloths = this.equippedProvider.apply(player);
        List<Cloth> equip = this.oldCloths.values().stream().filter(Objects::nonNull).toList();
        List<Cloth> list = ((String)this.currentLayer.m_14418_()).equals("current") ? equip : ClothingLoader.instance.getAvailablesClothsCollectionForPlayer((Player)Minecraft.m_91087_().f_91074_, "all", (LayerDef[])this.currentLayer.m_14419_());
        if (!filter.isEmpty()) {
            list = list.stream().filter(v -> v.name().toLowerCase().contains(filter) || !v.collection().equals("default") && v.collection().toLowerCase().contains(filter)).toList();
        }
        layout.setCloths(list, c -> {
            ClothButtonComponent bt = new ClothButtonComponent((Cloth)c, a -> {
                a.m_7435_(Minecraft.m_91087_().m_91106_());
                if (this.oldCloths.get(c.layer().id) == c) {
                    dt.getAppearence().setCloth(c.layer().id, null);
                    Channels.MAIN.clientHandle().send(new CosmeticsPackets.EquipCloth(new ResourceLocation("null", "null"), c.layer().getId()));
                } else {
                    dt.getAppearence().setCloth(c.layer().id, (Cloth)c);
                    Channels.MAIN.clientHandle().send(new CosmeticsPackets.EquipCloth(c.id(), c.layer().toString()));
                }
                this.oldCloths = this.equippedProvider.apply(player);
                this.updateSelected(layout, this.oldCloths.values().stream().filter(Objects::nonNull).toList());
            }, layout);
            bt.onClothHovered(v -> {
                if (v != null) {
                    dt.getAppearence().setCloth((Cloth)v);
                } else {
                    this.oldCloths.forEach((a, v1) -> dt.getAppearence().setCloth((String)a, (Cloth)v1));
                }
            });
            return bt;
        });
        this.updateSelected(layout, equip);
    }

    private void updateSelected(ScrollableCloths layout, List<Cloth> equipped) {
        for (ClothButtonComponent cb : layout.children()) {
            cb.setSelected(equipped.stream().anyMatch(v -> v.id().equals((Object)cb.getCloth().id())));
        }
    }

    private void createOutfitWindow(Button bt, int index) {
        Minecraft.m_91087_().m_91152_((Screen)new OutfitPopupGui(this, index, bt));
    }

    public boolean m_7043_() {
        return false;
    }
}

