/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client.gui.components;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.client.ClothingModel;
import com.diamssword.characters.client.gui.components.ScrollTooltipPositioner;
import com.diamssword.characters.client.gui.components.ScrollableCloths;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Vector3f;

public class ClothButtonComponent
extends Button {
    public static final ResourceLocation TEXTURE = Characters.asRessource("textures/gui/cloth_bg.png");
    private Cloth cloth;
    private final ClothingModel<AbstractClientPlayer> model = new ClothingModel(false, 0, false);
    private final ClothingModel<AbstractClientPlayer> model1 = new ClothingModel(false, 1, true);
    protected final EntityRenderDispatcher dispatcher;
    protected final MultiBufferSource.BufferSource entityBuffers;
    private boolean hoveredSent = false;
    private boolean selected = false;
    private final List<Consumer<Cloth>> onHovered = new ArrayList<Consumer<Cloth>>();
    private boolean wasHovered;
    private long lastHoveredTime;
    private long tooltipDelay;
    public final ScrollableCloths parent;

    public ClothButtonComponent(Cloth cloth, Button.OnPress action, ScrollableCloths parent) {
        super(0, 0, 0, 0, (Component)Component.m_237113_((String)""), action, Button.f_252438_);
        this.parent = parent;
        this.setCloth(cloth);
        Minecraft client = Minecraft.m_91087_();
        this.dispatcher = client.m_91290_();
        this.entityBuffers = client.m_91269_().m_110104_();
    }

    public void setHeight(int height) {
        this.f_93619_ = height;
    }

    public void setCloth(Cloth cloth) {
        this.cloth = cloth;
        MutableComponent tool = Component.m_237113_((String)cloth.name().replaceAll("/", " ").replaceAll("_", " "));
        if (!cloth.collection().equals("default")) {
            tool.m_7220_((Component)Component.m_237113_((String)("\n" + cloth.collection())).m_130944_(new ChatFormatting[]{ChatFormatting.BLUE, ChatFormatting.ITALIC}));
        }
        this.m_257544_(Tooltip.m_257550_((Component)tool));
    }

    public Cloth getCloth() {
        return this.cloth;
    }

    public boolean selected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void onClothHovered(Consumer<Cloth> callback) {
        this.onHovered.add(callback);
    }

    public void setHover(boolean hovered) {
        this.f_93622_ = hovered;
        if (this.f_93622_) {
            if (!this.hoveredSent) {
                this.onHovered.forEach(c -> c.accept(this.cloth));
            }
            this.hoveredSent = true;
        } else if (this.hoveredSent) {
            this.onHovered.forEach(c -> c.accept(null));
            this.hoveredSent = false;
        }
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        if (this.f_93624_) {
            this.m_87963_(context, mouseX, mouseY, delta);
            this.applyTooltip();
        }
    }

    private void applyTooltip() {
        if (this.m_278622_() != null) {
            Screen screen;
            boolean bl;
            boolean bl2 = bl = this.f_93622_ || this.m_93696_() && Minecraft.m_91087_().m_264529_().m_264505_();
            if (bl != this.wasHovered) {
                if (bl) {
                    this.lastHoveredTime = Util.m_137550_();
                }
                this.wasHovered = bl;
            }
            if (bl && Util.m_137550_() - this.lastHoveredTime > this.tooltipDelay && (screen = Minecraft.m_91087_().f_91080_) != null) {
                screen.m_262791_(this.m_278622_(), this.m_262860_(), this.m_93696_());
            }
        }
    }

    protected ClientTooltipPositioner m_262860_() {
        return new ScrollTooltipPositioner(this);
    }

    protected void m_87963_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        int x = this.m_252754_() + 1;
        int y = this.m_252907_() + 1;
        int a = this.m_252754_() + this.m_5711_() - 1;
        int b = this.m_252907_() + this.m_93694_() - 1;
        context.m_280509_(x, y, a, b, this.selected ? -5123408 : -3750202);
        context.m_280656_(x, a - 1, this.m_252907_(), -1);
        context.m_280315_(this.m_252754_(), y - 1, b, -1);
        context.m_280656_(x, a - 1, this.m_252907_() + this.m_93694_() - 1, -11184811);
        context.m_280315_(this.m_252754_() + this.m_5711_() - 1, y - 1, b, -11184811);
        this.drawClothing(context, mouseX);
    }

    public void drawClothing(GuiGraphics context, int mouseX) {
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        float scale = this.cloth.layer().getDisplayMode() == 1 ? 30.0f : (float)(this.cloth.layer().getDisplayMode() == 2 ? 40 : 20);
        matrices.m_252880_((float)this.m_252754_() + (float)this.f_93618_ / 2.0f, (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - 8.0f, 100.0f);
        if (this.cloth.layer().getDisplayMode() != 0) {
            if (this.cloth.layer().getDisplayMode() == 2) {
                matrices.m_252880_(0.0f, -((float)this.f_93619_ * 0.8f), 0.0f);
            } else {
                matrices.m_252880_(0.0f, (float)this.f_93619_ / 3.0f, 0.0f);
            }
            matrices.m_252781_(Axis.f_252529_.m_252977_(-15.0f));
        }
        matrices.m_85841_(scale, scale, scale);
        float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.m_252754_()) - (float)this.f_93618_ / 2.0f) / 40.0f));
        matrices.m_252781_(Axis.f_252436_.m_252977_(180.0f + yRotation * 0.6f));
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.m_114468_(false);
        this.renderLayer(matrices, (MultiBufferSource)this.entityBuffers, 0xF000F0);
        this.dispatcher.m_114468_(true);
        this.entityBuffers.m_109911_();
        Lighting.m_84931_();
        matrices.m_85849_();
    }

    public void renderLayer(PoseStack matrices, MultiBufferSource vertexConsumers, int light) {
        this.model.f_102610_ = false;
        this.model1.f_102610_ = false;
        int pack = OverlayTexture.m_118093_((int)OverlayTexture.m_118088_((float)0.0f), (int)OverlayTexture.m_118096_((boolean)false));
        this.model.m_7695_(matrices, vertexConsumers.m_6299_(this.model.m_103119_(new ResourceLocation(this.cloth.id().m_135827_(), "textures/cloth/" + this.cloth.id().m_135815_() + ".png"))), light, pack, 1.0f, 1.0f, 1.0f, 1.0f);
        this.model1.m_7695_(matrices, vertexConsumers.m_6299_(this.model1.m_103119_(new ResourceLocation(this.cloth.id().m_135827_(), "textures/cloth/" + this.cloth.id().m_135815_() + ".png"))), light, pack, 1.0f, 1.0f, 1.0f, 1.0f);
    }
}

