/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.client.gui.components;

import com.diamssword.characters.client.gui.components.BaseComponent;
import com.diamssword.characters.client.gui.components.Sizing;
import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import org.joml.Vector3f;

public class PlayerComponent
extends BaseComponent {
    protected final EntityRenderDispatcher dispatcher;
    protected final MultiBufferSource.BufferSource entityBuffers;
    protected final Player entity;
    protected float mouseRotation = 0.0f;
    protected float scale = 1.0f;
    protected boolean lookAtCursor = false;
    protected boolean allowMouseRotation = false;
    protected boolean scaleToFit = false;
    protected int rotation = 0;
    protected boolean showNametag = false;
    protected Consumer<PoseStack> transform = matrixStack -> {};

    public PlayerComponent(Sizing sizingX, Sizing sizingY, Player entity) {
        super(sizingX, sizingY);
        Minecraft client = Minecraft.m_91087_();
        this.dispatcher = client.m_91290_();
        this.entityBuffers = client.m_91269_().m_110104_();
        this.entity = entity;
    }

    public PlayerComponent(Sizing sizingX, Sizing sizingY) {
        this(sizingX, sizingY, (Player)new RemotePlayer(Minecraft.m_91087_().f_91073_, Minecraft.m_91087_().f_91074_.m_36316_()){

            public boolean m_5833_() {
                return false;
            }

            public boolean m_7500_() {
                return false;
            }
        });
    }

    @Override
    protected int determineVerticalContentSize(Sizing sizing) {
        return this.width;
    }

    @Override
    public void mount(int x, int y, int width, int height) {
        Sizing horizontalSizing = this.sizeX;
        Sizing verticalSizing = this.sizeY;
        this.x = x;
        this.y = y;
        this.width = horizontalSizing.inflate(width, this::determineHorizontalContentSize);
        this.height = verticalSizing.inflate(height, this::determineVerticalContentSize);
    }

    public void m_88315_(GuiGraphics context, int mouseX, int mouseY, float delta) {
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_252880_((float)this.x + (float)this.width / 2.0f, (float)this.y + (float)this.height * 0.6f, 100.0f);
        matrices.m_85841_(75.0f * this.scale * (float)this.width / 64.0f, -75.0f * this.scale * (float)this.height / 64.0f, 75.0f * this.scale);
        matrices.m_252880_(0.0f, this.entity.m_20206_() / -2.0f, 0.0f);
        this.transform.accept(matrices);
        if (this.lookAtCursor) {
            float xRotation = (float)Math.toDegrees(Math.atan(((float)(mouseY - this.y) - (float)this.height / 2.0f) / 40.0f));
            float yRotation = (float)Math.toDegrees(Math.atan(((float)(mouseX - this.x) - (float)this.width / 2.0f) / 40.0f));
            this.entity.f_20886_ = -yRotation;
            this.entity.f_19859_ = -yRotation;
            this.entity.f_19860_ = xRotation * 0.65f;
            if (xRotation == 0.0f) {
                xRotation = 0.1f;
            }
            matrices.m_252781_(Axis.f_252529_.m_252977_(xRotation * 0.15f));
            matrices.m_252781_(Axis.f_252436_.m_252977_(yRotation * 0.15f));
        } else {
            matrices.m_252781_(Axis.f_252529_.m_252977_(35.0f));
            matrices.m_252781_(Axis.f_252436_.m_252977_(-45.0f + this.mouseRotation));
        }
        matrices.m_252781_(Axis.f_252436_.m_252977_((float)this.rotation));
        RenderSystem.setShaderLights((Vector3f)new Vector3f(0.15f, 1.0f, 0.0f), (Vector3f)new Vector3f(0.15f, -1.0f, 0.0f));
        this.dispatcher.m_114468_(false);
        this.dispatcher.m_114384_((Entity)this.entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrices, (MultiBufferSource)this.entityBuffers, 0xF000F0);
        this.dispatcher.m_114468_(true);
        this.entityBuffers.m_109911_();
        Lighting.m_84931_();
        matrices.m_85849_();
    }

    public Player entity() {
        return this.entity;
    }

    public PlayerComponent allowMouseRotation(boolean allowMouseRotation) {
        this.allowMouseRotation = allowMouseRotation;
        return this;
    }

    public PlayerComponent rotation(int rotation) {
        this.rotation = rotation;
        return this;
    }

    public boolean allowMouseRotation() {
        return this.allowMouseRotation;
    }

    public PlayerComponent lookAtCursor(boolean lookAtCursor) {
        this.lookAtCursor = lookAtCursor;
        return this;
    }

    public boolean lookAtCursor() {
        return this.lookAtCursor;
    }

    public PlayerComponent scale(float scale) {
        this.scale = scale;
        return this;
    }

    public float scale() {
        return this.scale;
    }

    public PlayerComponent scaleToFit(boolean scaleToFit) {
        this.scaleToFit = scaleToFit;
        if (scaleToFit) {
            float xScale = 0.6f / this.entity.m_20205_();
            float yScale = 0.6f / this.entity.m_20206_();
            this.scale(Math.min(xScale, yScale));
        }
        return this;
    }

    public boolean scaleToFit() {
        return this.scaleToFit;
    }

    public PlayerComponent transform(Consumer<PoseStack> transform) {
        this.transform = transform;
        return this;
    }

    public Consumer<PoseStack> transform() {
        return this.transform;
    }
}

