/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.commands;

import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.IPlayerAppearance;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.storage.ClothingLoader;
import com.mojang.brigadier.LiteralMessage;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collection;
import java.util.Iterator;
import java.util.Optional;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ClothCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82981_(ClothingLoader.instance.getClothIds().stream().map(ResourceLocation::toString), (SuggestionsBuilder)builder);
    private static final SuggestionProvider<CommandSourceStack> SUGGESTION_PROVIDER_LAYER = (context, builder) -> SharedSuggestionProvider.m_82970_(ClothingLoader.instance.getLayers().keySet(), (SuggestionsBuilder)builder);

    public static void register(LiteralArgumentBuilder<CommandSourceStack> builder) {
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)builder.requires(ctx -> ctx.m_6761_(2));
        for (String str : new String[]{"unlock", "lock", "set"}) {
            root.then(Commands.m_82127_((String)str).then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGESTION_PROVIDER).executes(ctx -> ClothCommand.Exec((CommandContext<CommandSourceStack>)ctx, str)))));
        }
        root.then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91470_()).then(Commands.m_82129_((String)"layer", (ArgumentType)StringArgumentType.string()).suggests(SUGGESTION_PROVIDER_LAYER).executes(ClothCommand::ExecRemove))));
    }

    private static int ExecRemove(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        Iterator iterator;
        Collection players = EntityArgument.m_91477_(ctx, (String)"player");
        String layerID = StringArgumentType.getString(ctx, (String)"layer");
        Optional<LayerDef> layer = ClothingLoader.instance.getLayer(layerID);
        if (layer.isPresent() && (iterator = players.iterator()).hasNext()) {
            ServerPlayer player = (ServerPlayer)iterator.next();
            IPlayerAppearance app = ComponentManager.getPlayerDatas((Player)player).getAppearence();
            app.removeCloth(layerID);
            ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(" is now naked in the cloth layer: " + layerID), true);
            ComponentManager.syncPlayerDatas((Player)player);
            return 1;
        }
        throw new SimpleCommandExceptionType((Message)new LiteralMessage("Layer not found with id: " + layerID)).create();
    }

    private static int Exec(CommandContext<CommandSourceStack> ctx, String action) throws CommandSyntaxException {
        Iterator iterator;
        Collection players = EntityArgument.m_91477_(ctx, (String)"player");
        ResourceLocation clothID = ResourceLocationArgument.m_107011_(ctx, (String)"id");
        Optional<Cloth> cloth = ClothingLoader.instance.getCloth(clothID);
        if (cloth.isPresent() && (iterator = players.iterator()).hasNext()) {
            ServerPlayer player = (ServerPlayer)iterator.next();
            IPlayerAppearance app = ComponentManager.getPlayerDatas((Player)player).getAppearence();
            switch (action) {
                case "unlock": {
                    app.unlockCloth(cloth.get());
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(" have unlocked the cloth: " + clothID), true);
                    break;
                }
                case "lock": {
                    app.lockCLoth(cloth.get());
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(" have lost the cloth: " + clothID), true);
                    break;
                }
                case "set": {
                    app.setCloth(cloth.get());
                    ((CommandSourceStack)ctx.getSource()).m_288197_(() -> Component.m_237113_((String)"").m_7220_(player.m_5446_()).m_130946_(" is now wearing: " + clothID), true);
                }
            }
            ComponentManager.syncPlayerDatas((Player)player);
            return 1;
        }
        throw new SimpleCommandExceptionType((Message)new LiteralMessage("Cloth not found with id: " + clothID)).create();
    }
}

