/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.forge;

import com.diamssword.characters.Characters;
import com.diamssword.characters.forge.PlayerCharactersImpl;
import com.diamssword.characters.forge.PlayerCharactersProvider;
import com.diamssword.characters.forge.PlayerDataProvider;
import com.diamssword.characters.forge.PlayerDatasImpl;
import com.diamssword.characters.forge.SkinServerCacheImpl;
import com.diamssword.characters.forge.SkinServerCacheProvider;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEvents {
    public static final Map<ResourceLocation, Capability<?>> CAPABILITY_MAP = new HashMap();
    public static final ResourceLocation APPEARANCE = Characters.asRessource("appearance");
    public static final ResourceLocation CHARACTERS = Characters.asRessource("characters");
    public static final ResourceLocation SKIN_SERVER = Characters.asRessource("skin_server_cache");
    public static final Capability<PlayerDatasImpl> PLAYER_APPEARANCE = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerDatasImpl>(){});
    public static final Capability<SkinServerCacheImpl> SKIN_SERVER_CACHE = CapabilityManager.get((CapabilityToken)new CapabilityToken<SkinServerCacheImpl>(){});
    public static final Capability<PlayerCharactersImpl> PLAYER_CHARACTERS = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerCharactersImpl>(){});

    public static void register(RegisterCapabilitiesEvent event) {
        CAPABILITY_MAP.put(APPEARANCE, PLAYER_APPEARANCE);
        CAPABILITY_MAP.put(CHARACTERS, PLAYER_CHARACTERS);
        CAPABILITY_MAP.put(SKIN_SERVER, SKIN_SERVER_CACHE);
        event.register(PlayerDatasImpl.class);
        event.register(SkinServerCacheImpl.class);
        event.register(PlayerCharactersImpl.class);
    }

    @SubscribeEvent
    public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player pl = (Player)object;
            PlayerDataProvider provider = new PlayerDataProvider(pl);
            event.addCapability(APPEARANCE, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
            PlayerCharactersProvider provider1 = new PlayerCharactersProvider(pl);
            event.addCapability(CHARACTERS, (ICapabilityProvider)provider1);
            event.addListener(provider1::invalidate);
        }
    }

    @SubscribeEvent
    public static void onAttachCapabilitiesWorld(AttachCapabilitiesEvent<Level> event) {
        ServerLevel serverLevel;
        Object object = event.getObject();
        if (object instanceof ServerLevel && (serverLevel = (ServerLevel)object).m_46472_() == Level.f_46428_) {
            SkinServerCacheProvider provider = new SkinServerCacheProvider();
            event.addCapability(SKIN_SERVER, (ICapabilityProvider)provider);
            event.addListener(provider::invalidate);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.player instanceof ServerPlayer) {
            event.player.getCapability(PLAYER_APPEARANCE).ifPresent(PlayerDatasImpl::serverTick);
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player oldPlayer = event.getOriginal();
        Player newPlayer = event.getEntity();
        oldPlayer.getCapability(PLAYER_APPEARANCE).ifPresent(oldStats -> newPlayer.getCapability(PLAYER_APPEARANCE).ifPresent(newStats -> newStats.fromNBT(oldStats.toNBT())));
        oldPlayer.getCapability(PLAYER_CHARACTERS).ifPresent(oldStats -> newPlayer.getCapability(PLAYER_CHARACTERS).ifPresent(newStats -> newStats.readFromNbt(oldStats.toNBT())));
    }
}

