/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.network.owoNetwork;

import com.diamssword.characters.network.owoNetwork.ClientAccess;
import com.diamssword.characters.network.owoNetwork.NetworkException;
import com.diamssword.characters.network.owoNetwork.ReflectionUtils;
import com.diamssword.characters.network.owoNetwork.ServerAccess;
import com.diamssword.characters.network.owoNetwork.serialization.RecordSerializer;
import dev.architectury.networking.NetworkManager;
import dev.architectury.platform.Platform;
import dev.architectury.utils.Env;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OwoNetChannel {
    public static final Logger LOGGER = LogManager.getLogger((String)"owo_netork_impl");
    static final Map<ResourceLocation, OwoNetChannel> REGISTERED_CHANNELS = new HashMap<ResourceLocation, OwoNetChannel>();
    private final Map<Class<?>, IndexedSerializer<?>> serializersByClass = new HashMap();
    final Int2ObjectMap<IndexedSerializer<?>> serializersByIndex = new Int2ObjectOpenHashMap();
    private final List<ChannelHandler<Record, ClientAccess>> clientHandlers = new ArrayList<ChannelHandler<Record, ClientAccess>>();
    private final List<ChannelHandler<Record, ServerAccess>> serverHandlers = new ArrayList<ChannelHandler<Record, ServerAccess>>();
    private final Reference2IntMap<Class<?>> deferredClientSerializers = new Reference2IntOpenHashMap();
    final ResourceLocation packetId;
    private final String ownerClassName;
    private ClientHandle clientHandle = null;
    private ServerHandle serverHandle = null;

    public static OwoNetChannel create(ResourceLocation id) {
        return new OwoNetChannel(id, ReflectionUtils.getCallingClassName(2));
    }

    public void init() {
        NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.C2S, (ResourceLocation)this.packetId, (buf, context) -> {
            int handlerIndex = buf.m_130242_();
            Object message = ((IndexedSerializer)this.serializersByIndex.get((int)handlerIndex)).serializer.read(buf);
            context.getPlayer().m_20194_().execute(() -> this.serverHandlers.get(handlerIndex).handle((Record)message, new ServerAccess((ServerPlayer)context.getPlayer())));
        });
        if (Platform.getEnvironment() == Env.CLIENT) {
            NetworkManager.registerReceiver((NetworkManager.Side)NetworkManager.Side.S2C, (ResourceLocation)this.packetId, this::handleClient);
        }
    }

    private OwoNetChannel(ResourceLocation id, String ownerClassName) {
        if (REGISTERED_CHANNELS.containsKey(id)) {
            throw new IllegalStateException("Channel with id '" + id + "' was already registered from class '" + OwoNetChannel.REGISTERED_CHANNELS.get((Object)id).ownerClassName + "'");
        }
        this.deferredClientSerializers.defaultReturnValue(-1);
        this.packetId = id;
        this.ownerClassName = ownerClassName;
        this.clientHandlers.add(null);
        this.serverHandlers.add(null);
        REGISTERED_CHANNELS.put(id, this);
    }

    private void handleClient(FriendlyByteBuf buf, NetworkManager.PacketContext context) {
        int handlerIndex = buf.m_130242_();
        Object message = ((IndexedSerializer)this.serializersByIndex.get((int)(-handlerIndex))).serializer.read(buf);
        Minecraft.m_91087_().execute(() -> this.clientHandlers.get(handlerIndex).handle((Record)message, new ClientAccess(Minecraft.m_91087_().m_91403_())));
    }

    public <R extends Record> void registerClientbound(Class<R> messageClass, ChannelHandler<R, ClientAccess> handler) {
        int deferredIndex = this.deferredClientSerializers.removeInt(messageClass);
        if (deferredIndex != -1) {
            this.clientHandlers.set(deferredIndex, handler);
            return;
        }
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, Env.CLIENT);
        this.clientHandlers.add(handler);
    }

    public <R extends Record> void registerClientboundDeferred(Class<R> messageClass) {
        int index = this.clientHandlers.size();
        this.createSerializer(messageClass, index, Env.CLIENT);
        this.clientHandlers.add(null);
        this.deferredClientSerializers.put(messageClass, index);
    }

    public <R extends Record> void registerServerbound(Class<R> messageClass, ChannelHandler<R, ServerAccess> handler) {
        int index = this.serverHandlers.size();
        this.createSerializer(messageClass, index, Env.SERVER);
        this.serverHandlers.add(handler);
    }

    public ClientHandle clientHandle() {
        if (Platform.getEnvironment() != Env.CLIENT) {
            throw new NetworkException("Cannot obtain client handle in environment type '" + Platform.getEnvironment() + "'");
        }
        if (this.clientHandle == null) {
            this.clientHandle = new ClientHandle();
        }
        return this.clientHandle;
    }

    public ServerHandle serverHandle(MinecraftServer server) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = server.m_6846_().m_11314_();
        return handle;
    }

    public ServerHandle serverHandle(Collection<ServerPlayer> targets) {
        ServerHandle handle = this.getServerHandle();
        handle.targets = targets;
        return handle;
    }

    public ServerHandle serverHandle(Player player) {
        if (!(player instanceof ServerPlayer)) {
            throw new NetworkException("'player' must be a 'ServerPlayerEntity'");
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        ServerHandle handle = this.getServerHandle();
        handle.targets = Collections.singleton(serverPlayer);
        return handle;
    }

    public ServerHandle serverHandle(BlockEntity entity) {
        if (entity.m_58904_().f_46443_) {
            throw new NetworkException("Server handle cannot be obtained on the client");
        }
        return this.serverHandle(OwoNetChannel.tracking(entity));
    }

    public static Collection<ServerPlayer> tracking(BlockEntity blockEntity) {
        Objects.requireNonNull(blockEntity, "BlockEntity cannot be null");
        if (!blockEntity.m_58898_() || blockEntity.m_58904_().m_5776_()) {
            throw new IllegalArgumentException("Only supported on server worlds!");
        }
        return OwoNetChannel.tracking((ServerLevel)blockEntity.m_58904_(), blockEntity.m_58899_());
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, BlockPos pos) {
        Objects.requireNonNull(pos, "BlockPos cannot be null");
        return OwoNetChannel.tracking(world, new ChunkPos(pos));
    }

    public static Collection<ServerPlayer> tracking(ServerLevel world, ChunkPos pos) {
        Objects.requireNonNull(world, "The world cannot be null");
        Objects.requireNonNull(pos, "The chunk pos cannot be null");
        return world.m_7726_().f_8325_.m_183262_(pos, false);
    }

    public ServerHandle serverHandle(ServerLevel world, BlockPos pos) {
        return this.serverHandle(OwoNetChannel.tracking(world, pos));
    }

    private ServerHandle getServerHandle() {
        if (this.serverHandle == null) {
            this.serverHandle = new ServerHandle();
        }
        return this.serverHandle;
    }

    private <R extends Record> void createSerializer(Class<R> messageClass, int handlerIndex, Env target) {
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer == null) {
            IndexedSerializer<R> indexedSerializer = IndexedSerializer.create(RecordSerializer.create(messageClass), handlerIndex, target);
            this.serializersByClass.put(messageClass, indexedSerializer);
            this.serializersByIndex.put(target == Env.CLIENT ? -handlerIndex : handlerIndex, indexedSerializer);
        } else if (serializer.handlerIndex(target) == -1) {
            serializer.setHandlerIndex(handlerIndex, target);
            this.serializersByIndex.put(target == Env.CLIENT ? -handlerIndex : handlerIndex, serializer);
        } else {
            throw new IllegalStateException("Message class '" + messageClass.getName() + "' is already registered for target environment " + target);
        }
    }

    private <R extends Record> FriendlyByteBuf encode(R message, Env target) {
        FriendlyByteBuf buffer = new FriendlyByteBuf(Unpooled.buffer());
        Class<?> messageClass = message.getClass();
        if (!this.serializersByClass.containsKey(messageClass)) {
            throw new NetworkException("Message class '" + messageClass + "' is not registered");
        }
        IndexedSerializer<?> serializer = this.serializersByClass.get(messageClass);
        if (serializer.handlerIndex(target) == -1) {
            throw new NetworkException("Message class '" + messageClass + "' has not handler registered for target environment " + target);
        }
        buffer.m_130130_(serializer.handlerIndex(target));
        serializer.serializer.write(buffer, message);
        return buffer;
    }

    private void verify() {
        if (Platform.getEnvironment() == Env.CLIENT && this.deferredClientSerializers.size() > 0) {
            throw new NetworkException("Some deferred client handlers for channel " + this.packetId + " haven't been registered: " + this.deferredClientSerializers.keySet().stream().map(Class::getName).collect(Collectors.joining(", ")));
        }
    }

    public class ClientHandle {
        public <R extends Record> void send(R message) {
            NetworkManager.sendToServer((ResourceLocation)OwoNetChannel.this.packetId, (FriendlyByteBuf)OwoNetChannel.this.encode(message, Env.SERVER));
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                this.send(message);
            }
        }
    }

    public class ServerHandle {
        private Collection<ServerPlayer> targets = Collections.emptySet();

        public <R extends Record> void send(R message) {
            NetworkManager.sendToPlayers(this.targets, (ResourceLocation)OwoNetChannel.this.packetId, (FriendlyByteBuf)OwoNetChannel.this.encode(message, Env.CLIENT));
            this.targets = null;
        }

        @SafeVarargs
        public final <R extends Record> void send(R ... messages) {
            for (R message : messages) {
                NetworkManager.sendToPlayers(this.targets, (ResourceLocation)OwoNetChannel.this.packetId, (FriendlyByteBuf)OwoNetChannel.this.encode(message, Env.CLIENT));
            }
            this.targets = null;
        }
    }

    static final class IndexedSerializer<R extends Record> {
        private int clientHandlerIndex = -1;
        private int serverHandlerIndex = -1;
        final RecordSerializer<R> serializer;

        private IndexedSerializer(RecordSerializer<R> serializer) {
            this.serializer = serializer;
        }

        public static <R extends Record> IndexedSerializer<R> create(RecordSerializer<R> serializer, int index, Env target) {
            return new IndexedSerializer<R>(serializer).setHandlerIndex(index, target);
        }

        public IndexedSerializer<R> setHandlerIndex(int index, Env target) {
            switch (target) {
                case CLIENT: {
                    this.clientHandlerIndex = index;
                    break;
                }
                case SERVER: {
                    this.serverHandlerIndex = index;
                }
            }
            return this;
        }

        public int handlerIndex(Env target) {
            return switch (target) {
                default -> throw new IncompatibleClassChangeError();
                case Env.CLIENT -> this.clientHandlerIndex;
                case Env.SERVER -> this.serverHandlerIndex;
            };
        }
    }

    public static interface ChannelHandler<R extends Record, E extends EnvironmentAccess<?, ?, ?>> {
        public void handle(R var1, E var2);
    }

    public static interface EnvironmentAccess<P extends Player, R, N> {
        public P player();

        public R runtime();

        public N netHandler();
    }
}

