/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.stats.IPlayerStats;
import com.diamssword.characters.api.stats.StatsRole;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.DictionaryPackets;
import com.diamssword.characters.storage.PlayerStats;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import dev.architectury.event.events.common.PlayerEvent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class ClassesLoader
implements ResourceManagerReloadListener {
    private static final int MAX_LEVEL = 100;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<String, BiFunction<String, JsonObject, ? extends StatsRole>> roleFactories = new HashMap<String, BiFunction<String, JsonObject, ? extends StatsRole>>();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static ClassesLoader instance = new ClassesLoader();
    private final Map<String, StatsRole> roles = new HashMap<String, StatsRole>();
    private final Map<Integer, Integer> progression = new HashMap<Integer, Integer>();
    private boolean shouldSync = false;

    public ResourceLocation getId() {
        return new ResourceLocation(this.m_7812_());
    }

    public String m_7812_() {
        return "character_sheet:classes";
    }

    public static Optional<StatsRole> getRole(String id) {
        return Optional.ofNullable(ClassesLoader.instance.roles.get(id));
    }

    public static Map<String, StatsRole> getRoles() {
        return ClassesLoader.instance.roles;
    }

    public static void registerRole(String id, BiFunction<String, JsonObject, ? extends StatsRole> factory) {
        roleFactories.put(id, factory);
    }

    public static void initEvents() {
        PlayerEvent.PLAYER_CLONE.register((oldPlayer, newPlayer, alive) -> {
            IPlayerStats patt2371$temp;
            if (!alive && (patt2371$temp = ComponentManager.getPlayerDatas((Player)newPlayer).getStats()) instanceof PlayerStats) {
                PlayerStats ps = (PlayerStats)patt2371$temp;
                ps.onPlayerRespawn();
            }
        });
    }

    public static void onLevelChange(Player pl, String role, int level) {
        ClassesLoader.getRole(role).ifPresent(r -> r.onLevelChange(pl, level));
    }

    public int getXpCostForLevel(int palier) {
        int res = 0;
        int last = 0;
        for (Map.Entry<Integer, Integer> p : this.progression.entrySet()) {
            if (palier >= p.getKey() || p.getKey() <= last) continue;
            last = p.getKey();
            res = p.getValue();
        }
        return res;
    }

    public int missingXpForNext(Player player, String competence) {
        IPlayerStats st = ComponentManager.getPlayerDatas(player).getStats();
        int xp = st.getXp(competence);
        int lev = st.getLevel(competence);
        if (lev >= 100) {
            return -1;
        }
        int l = this.getXpCostForLevel(lev + 1);
        return l - xp;
    }

    public float percentOfXpForNext(Player player, String competence) {
        IPlayerStats st = ComponentManager.getPlayerDatas(player).getStats();
        int xp = st.getXp(competence);
        int lev = st.getLevel(competence);
        if (lev >= 100) {
            return 1.0f;
        }
        int l = this.getXpCostForLevel(lev + 1);
        return (float)xp / (float)l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager manager) {
        this.roles.clear();
        ResourceLocation id = Characters.asRessource("skills.json");
        Optional file = manager.m_213713_(id);
        if (file.isPresent()) {
            try (BufferedReader reader = ((Resource)file.get()).m_215508_();){
                this.readJson((JsonObject)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonObject.class));
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, this.getId(), exception});
            }
        }
        this.shouldSync = true;
    }

    public void worldTick(MinecraftServer server) {
        if (this.shouldSync) {
            this.shouldSync = false;
            Channels.serverHandle(server).send(new DictionaryPackets.ClassesList(this));
        }
    }

    private void readJson(JsonObject jsonElement) {
        this.roles.clear();
        this.progression.clear();
        jsonElement.keySet().forEach(v -> {
            JsonObject ob = jsonElement.getAsJsonObject(v);
            if (v.equals("progression")) {
                ob.keySet().forEach(v1 -> {
                    try {
                        int key = Integer.parseInt(v1);
                        int val = ob.get(v1).getAsInt();
                        this.progression.put(key, val);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                });
            } else if (!ob.has("disabled") || !ob.get("disabled").getAsBoolean()) {
                if (ob.has("name")) {
                    BiFunction<String, JsonObject, ? extends StatsRole> fac = roleFactories.get(v);
                    if (fac == null) {
                        fac = (i, d) -> new StatsRole((String)i, (JsonObject)d){

                            @Override
                            public void init() {
                            }
                        };
                    }
                    StatsRole r = fac.apply((String)v, ob);
                    this.roles.put((String)v, r);
                    r.init();
                } else {
                    LOGGER.error("Skill is missing name!");
                }
            }
        });
    }

    public static void serializer(FriendlyByteBuf write, ClassesLoader val) {
        JsonObject obj = new JsonObject();
        JsonObject o1 = new JsonObject();
        val.progression.forEach((k, v) -> o1.addProperty(k.toString(), (Number)v));
        obj.add("progression", (JsonElement)o1);
        val.roles.forEach((k, v) -> {
            JsonObject o = new JsonObject();
            o.addProperty("name", v.name);
            CompoundTag tag = new CompoundTag();
            tag.m_128359_("name", v.name);
            JsonArray arr = new JsonArray();
            for (int i : v.stages) {
                arr.add((Number)i);
            }
            o.add("stages", (JsonElement)arr);
            obj.add(k, (JsonElement)o);
        });
        write.m_130070_(obj.toString());
    }

    public static ClassesLoader unserializer(FriendlyByteBuf read) {
        ClassesLoader res = new ClassesLoader();
        res.readJson((JsonObject)GsonHelper.m_13794_((Gson)GSON, (String)read.m_130277_(), JsonObject.class));
        return res;
    }
}

