/*
 * Decompiled with CFR 0.152.
 */
package com.diamssword.characters.storage;

import com.diamssword.characters.Characters;
import com.diamssword.characters.api.ComponentManager;
import com.diamssword.characters.api.appearence.Cloth;
import com.diamssword.characters.api.appearence.LayerDef;
import com.diamssword.characters.client.CharactersClient;
import com.diamssword.characters.network.Channels;
import com.diamssword.characters.network.packets.DictionaryPackets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.player.Player;
import org.slf4j.Logger;

public class ClothingLoader
implements ResourceManagerReloadListener {
    public static ClothingLoader instance = new ClothingLoader();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Logger LOGGER = LogUtils.getLogger();
    private Map<ResourceLocation, Cloth> cloths = new HashMap<ResourceLocation, Cloth>();
    private Map<String, LayerDef> layers = new HashMap<String, LayerDef>();
    private final List<String> collections = new ArrayList<String>();
    private boolean shouldSync = false;

    public ResourceLocation getId() {
        return new ResourceLocation(this.m_7812_());
    }

    public Optional<Cloth> getCloth(ResourceLocation id) {
        return Optional.ofNullable(this.cloths.get(id));
    }

    public void addCloth(Cloth cloth) {
        this.cloths.put(cloth.id(), cloth);
        this.shouldSync = true;
    }

    public void addLayer(LayerDef layer) {
        this.layers.put(layer.getId(), layer);
        this.shouldSync = true;
    }

    public List<String> getCollections() {
        return new ArrayList<String>(this.collections);
    }

    public List<Cloth> getClothsCollection(String collection) {
        return this.cloths.values().stream().filter(v -> collection.equals("all") || v.collection().equals(collection)).toList();
    }

    public List<ResourceLocation> getClothIds() {
        return this.cloths.keySet().stream().toList();
    }

    public List<LayerDef> getClothLayers() {
        return this.layers.values().stream().filter(v -> !v.isBodyPart()).toList();
    }

    public Optional<LayerDef> getLayer(String id) {
        return Optional.ofNullable(this.layers.get(id));
    }

    public Map<String, LayerDef> getLayers() {
        return this.layers;
    }

    public List<Cloth> getAvailablesClothsCollectionForPlayer(Player ent, String collection, LayerDef ... layers) {
        List<String> lays = Arrays.stream(layers).map(LayerDef::getId).toList();
        if (ent.m_7500_()) {
            return this.cloths.values().stream().filter(v -> (collection.equals("all") || v.collection().equals(collection)) && lays.contains(v.layer().getId())).toList();
        }
        ArrayList<ResourceLocation> unl = ComponentManager.getPlayerDatas(ent).getAppearence().getUnlockedCloths();
        return this.cloths.values().stream().filter(v -> (collection.equals("all") || v.collection().equals(collection)) && lays.contains(v.layer().getId()) && unl.contains(v.layer().getId() + "_" + v.id())).toList();
    }

    public List<Cloth> getForLayers(LayerDef ... layers) {
        ArrayList<Cloth> res = new ArrayList<Cloth>();
        List<String> ls = Arrays.stream(layers).map(LayerDef::getId).toList();
        this.cloths.forEach((k, v) -> {
            if (ls.contains(v.layer().getId())) {
                res.add((Cloth)v);
            }
        });
        return res;
    }

    public String m_7812_() {
        return "character_sheet:cloths";
    }

    private void loadCLoths(String namespace, JsonArray array) {
        array.forEach(v -> {
            JsonObject ob = v.getAsJsonObject();
            if (ob.has("id")) {
                ResourceLocation id1 = new ResourceLocation(namespace, ob.get("layer").getAsString() + "/" + ob.get("id").getAsString());
                if (!this.cloths.containsKey(id1)) {
                    if (ob.has("layer") && ob.has("name")) {
                        LayerDef lay;
                        String col = "default";
                        if (ob.has("collection")) {
                            col = ob.get("collection").getAsString();
                        }
                        if ((lay = this.layers.get(ob.get("layer").getAsString())) != null) {
                            Cloth table = new Cloth(id1, ob.get("name").getAsString(), lay, col);
                            if (!this.collections.contains(col)) {
                                this.collections.add(col);
                            }
                            this.cloths.put(id1, table);
                        } else {
                            LOGGER.error("Layer for clothing with id: {} can't be parsed (layer {})", (Object)id1, (Object)ob.get("layer"));
                        }
                    } else {
                        LOGGER.error("Missing name of layer for clothing with id: {}", (Object)id1);
                    }
                } else {
                    LOGGER.error("Duplicate id for clothing: {}", (Object)id1);
                }
            } else {
                LOGGER.error("Clothing is missing ID!");
            }
        });
    }

    private void loadLayers(JsonArray array) {
        array.forEach(v -> {
            JsonObject ob = v.getAsJsonObject();
            if (ob.has("id")) {
                String id = ob.get("id").getAsString();
                if (!this.layers.containsKey(id)) {
                    if (ob.has("layer1")) {
                        try {
                            LayerDef layer = new LayerDef(id, ob.get("layer1").getAsInt());
                            if (ob.has("layer1")) {
                                layer.setLayer2(ob.get("layer1").getAsInt());
                            }
                            if (ob.has("forced")) {
                                layer.setForced(ob.get("forced").getAsBoolean());
                            }
                            if (ob.has("baseLayer")) {
                                layer.setBaseLayer(ob.get("baseLayer").getAsBoolean());
                            }
                            if (ob.has("bodyPart")) {
                                layer.setBodyPart(ob.get("bodyPart").getAsBoolean());
                            }
                            if (ob.has("displayMode")) {
                                layer.setDisplayMode(ob.get("displayMode").getAsInt());
                            }
                            if (ob.has("specialEditor")) {
                                layer.setSpecialEditor(ob.get("specialEditor").getAsString());
                            }
                            this.layers.put(id, layer);
                        }
                        catch (IllegalArgumentException e) {
                            LOGGER.error("Layer definition with id: {} can't be parsed ", (Object)id);
                        }
                    } else {
                        LOGGER.error("Layer {} is missing a layer1 field", (Object)id);
                    }
                } else {
                    LOGGER.error("Duplicate id for layer: {}", (Object)id);
                }
            } else {
                LOGGER.error("Layer is missing ID!");
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void m_6213_(ResourceManager manager) {
        this.cloths = new HashMap<ResourceLocation, Cloth>();
        this.collections.clear();
        this.layers.clear();
        ResourceLocation idL = Characters.asRessource("layers.json");
        Optional fileL = manager.m_213713_(idL);
        if (fileL.isPresent()) {
            try {
                BufferedReader reader = ((Resource)fileL.get()).m_215508_();
                try {
                    JsonArray jsonElement = (JsonArray)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonArray.class);
                    this.loadLayers(jsonElement);
                }
                finally {
                    ((Reader)reader).close();
                    this.shouldSync = true;
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{idL, this.m_7812_(), exception});
            }
        }
        Map resources = manager.m_214159_("cloths", identifier -> identifier.m_135815_().endsWith(".json"));
        resources.forEach((k, v) -> {
            try {
                BufferedReader reader = v.m_215508_();
                try {
                    JsonArray jsonElement = (JsonArray)GsonHelper.m_13776_((Gson)GSON, (Reader)reader, JsonArray.class);
                    this.loadCLoths(k.m_135827_(), jsonElement);
                }
                finally {
                    ((Reader)reader).close();
                    this.shouldSync = true;
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException exception) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{k, this.m_7812_(), exception});
            }
        });
    }

    public void worldTick(MinecraftServer server) {
        if (this.shouldSync) {
            this.shouldSync = false;
            Channels.serverHandle(server).send(new DictionaryPackets.ClothingList(this));
            if (server.m_129792_()) {
                CharactersClient.reloadPlayerRender();
            }
        }
    }

    public static void serializer(FriendlyByteBuf write, ClothingLoader val) {
        ListTag lays = new ListTag();
        ListTag list = new ListTag();
        ListTag collection = new ListTag();
        val.layers.forEach((u, v) -> lays.add((Object)v.toNBT()));
        val.cloths.forEach((u, v) -> {
            CompoundTag v1 = v.toNBT();
            v1.m_128359_("id", u.toString());
            list.add((Object)v1);
        });
        val.collections.forEach(c -> {
            CompoundTag v1 = new CompoundTag();
            v1.m_128359_("id", c);
            collection.add((Object)v1);
        });
        CompoundTag comp = new CompoundTag();
        comp.m_128365_("layers", (Tag)lays);
        comp.m_128365_("list", (Tag)list);
        comp.m_128365_("collection", (Tag)collection);
        write.m_130079_(comp);
    }

    public static ClothingLoader unserializer(FriendlyByteBuf read) {
        ClothingLoader loader = new ClothingLoader();
        CompoundTag comp = read.m_130260_();
        ListTag list = comp.m_128437_("list", 10);
        ListTag list1 = comp.m_128437_("collection", 10);
        ListTag lays = comp.m_128437_("layers", 10);
        list1.forEach(c -> loader.collections.add(((CompoundTag)c).m_128461_("id")));
        lays.forEach(el -> {
            LayerDef def = LayerDef.fromNBT((CompoundTag)el);
            if (def != null) {
                loader.layers.put(def.getId(), def);
            } else {
                LOGGER.error("Couldn't parse packet data for layer: {}", el);
            }
        });
        list.forEach(el -> {
            try {
                Cloth t;
                LayerDef lay = loader.layers.get(((CompoundTag)el).m_128461_("layer"));
                if (lay != null && (t = Cloth.fromNBT((CompoundTag)el, new ResourceLocation(((CompoundTag)el).m_128461_("id")), lay)) != null) {
                    loader.cloths.put(t.id(), t);
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't parse packet data for cloth: {}", el, (Object)e);
            }
        });
        return loader;
    }
}

