/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.config.modeEnum;
import kite.autoharvest.manager.ModeManager;
import kite.autoharvest.mode.BonemealMode;
import kite.autoharvest.mode.CompositeMode;
import kite.autoharvest.mode.FeedMode;
import kite.autoharvest.mode.FishingMode;
import kite.autoharvest.mode.HarvestMode;
import kite.autoharvest.mode.HoeMode;
import kite.autoharvest.mode.PlantMode;
import kite.autoharvest.mode.WeedMode;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_746;

public class ModeCommand {
    private static final List<String> MODE_NAMES = Arrays.asList("weed", "plant", "harvest", "farmer", "bonemeal", "feed", "fishing", "hoe");

    public static void register() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> {
            LiteralArgumentBuilder autoharvest = ClientCommandManager.literal((String)"autoharvest");
            autoharvest.then(ClientCommandManager.literal((String)"toggle").executes(ModeCommand::executeToggle));
            autoharvest.then(ClientCommandManager.literal((String)"mode").then(ClientCommandManager.argument((String)"mode", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> ModeCommand.suggestModes(builder)).executes(ModeCommand::executeSetMode)));
            dispatcher.register(autoharvest);
        });
    }

    private static CompletableFuture<Suggestions> suggestModes(SuggestionsBuilder builder) {
        for (String mode : MODE_NAMES) {
            builder.suggest(mode);
        }
        return builder.buildFuture();
    }

    private static int executeToggle(CommandContext<FabricClientCommandSource> context) {
        ModeManager.INSTANCE.toggle();
        return 1;
    }

    private static int executeSetMode(CommandContext<FabricClientCommandSource> context) {
        String modeName;
        class_746 player = class_310.method_1551().field_1724;
        switch (modeName = StringArgumentType.getString(context, (String)"mode").toLowerCase()) {
            case "weed": {
                ModeManager.INSTANCE.setCurrentMode(new WeedMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.weed;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.weed").getString())), false);
                }
                return 1;
            }
            case "plant": {
                ModeManager.INSTANCE.setCurrentMode(new PlantMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.plant;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.plant").getString())), false);
                }
                return 1;
            }
            case "hoe": {
                ModeManager.INSTANCE.setCurrentMode(new HoeMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.hoe;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.hoeing").getString())), false);
                }
                return 1;
            }
            case "bonemeal": {
                ModeManager.INSTANCE.setCurrentMode(new BonemealMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.bonemeal;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.bonemeal").getString())), false);
                }
                return 1;
            }
            case "harvest": {
                ModeManager.INSTANCE.setCurrentMode(new HarvestMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.harvest;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.harvest").getString())), false);
                }
                return 1;
            }
            case "farmer": {
                ModeManager.INSTANCE.setCurrentMode(CompositeMode.farmer());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.farmer;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + CompositeMode.farmmerode_string())), false);
                }
                return 1;
            }
            case "feed": {
                ModeManager.INSTANCE.setCurrentMode(new FeedMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.feed;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.feed").getString())), false);
                }
                return 1;
            }
            case "fishing": {
                ModeManager.INSTANCE.setCurrentMode(new FishingMode());
                AutoHarvestConfig.getInstance().thecurrentMode = modeEnum.fishing;
                AutoHarvestConfig.save();
                if (player != null) {
                    player.method_7353((class_2561)class_2561.method_43470((String)(class_2561.method_43471((String)"autoharvest.mode.switch").getString() + class_2561.method_43471((String)"autoharvest.mode.fishing").getString())), false);
                }
                return 1;
            }
        }
        if (player != null) {
            player.method_7353((class_2561)class_2561.method_43471((String)"autoharvest.mode.error"), false);
        }
        return 0;
    }
}

