/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.manager;

import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public enum ModeManager {
    INSTANCE;

    private AutoMode currentMode = null;
    private AutoMode cachedMode = null;
    private int tickCounter = 0;

    public void setCurrentMode(AutoMode mode) {
        this.currentMode = mode;
    }

    public void setCachedMode() {
        this.cachedMode = AutoHarvestConfig.thecurrentMode().setMode();
    }

    public void setMode(AutoMode mode) {
        if (this.currentMode != null) {
            this.currentMode.onDisable();
        }
        this.currentMode = mode;
        this.cachedMode = mode;
        if (class_310.method_1551().field_1724 != null) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43469((String)"autoharvest.message.mode.enabled", (Object[])new Object[]{mode.getName()}), false);
        }
    }

    public void clearMode() {
        if (this.currentMode != null) {
            this.currentMode.onDisable();
            if (class_310.method_1551().field_1724 != null) {
                class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"autoharvest.message.disabled"), false);
            }
        }
        this.currentMode = null;
    }

    public void toggle() {
        this.setCachedMode();
        if (this.currentMode != null) {
            this.clearMode();
        } else if (this.cachedMode != null) {
            this.setMode(this.cachedMode);
        } else {
            AutoMode mode = AutoHarvestConfig.thecurrentMode().setMode();
            this.setMode(mode);
        }
    }

    public void tick() {
        if (this.currentMode != null) {
            ++this.tickCounter;
            int interval = AutoHarvestConfig.ticksPerAction();
            if (this.tickCounter >= interval) {
                this.currentMode.tick();
                this.tickCounter = 0;
            }
        }
    }
}

