/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import java.util.List;
import java.util.stream.Collectors;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.mode.HarvestMode;
import kite.autoharvest.mode.PlantMode;

public class CompositeMode
implements AutoMode {
    private final List<AutoMode> modes;

    public CompositeMode(AutoMode ... modes) {
        this.modes = List.of(modes);
    }

    public static CompositeMode farmer() {
        return new CompositeMode(new PlantMode(), new HarvestMode());
    }

    @Override
    public void tick() {
        this.modes.forEach(AutoMode::tick);
    }

    @Override
    public String getName() {
        return this.modes.stream().map(AutoMode::getName).collect(Collectors.joining(" + "));
    }

    public static String farmmerode_string() {
        return CompositeMode.farmer().getName();
    }

    @Override
    public void onDisable() {
        this.modes.forEach(AutoMode::onDisable);
    }
}

