/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.mode.animal.Animals;
import kite.autoharvest.util.BoxUtil;
import kite.autoharvest.util.InteractionHelper;
import kite.autoharvest.util.ItemRefillHelpermain;
import kite.autoharvest.util.ItemRefillHelperoff;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1429;
import net.minecraft.class_1472;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class FeedMode
implements AutoMode {
    private static final Map<UUID, Long> INTERACT_COOLDOWN = new HashMap<UUID, Long>();
    private static long lastCleanupTime = 0L;
    private static final long CLEANUP_INTERVAL_MS = 5000L;

    private static long COOLDOWN_MS() {
        return AutoHarvestConfig.coolDown();
    }

    private boolean isOnCooldown(class_1297 entity) {
        Long lastInteract = INTERACT_COOLDOWN.get(entity.method_5667());
        if (lastInteract == null) {
            return false;
        }
        return System.currentTimeMillis() - lastInteract < FeedMode.COOLDOWN_MS();
    }

    private void markAsInteracted(class_1297 entity) {
        INTERACT_COOLDOWN.put(entity.method_5667(), System.currentTimeMillis());
    }

    private void cleanupCooldownCache() {
        long now = System.currentTimeMillis();
        if (now - lastCleanupTime < 5000L) {
            return;
        }
        INTERACT_COOLDOWN.entrySet().removeIf(entry -> now - (Long)entry.getValue() >= FeedMode.COOLDOWN_MS());
        lastCleanupTime = now;
    }

    private boolean canBreed(class_1297 entity) {
        if (entity instanceof class_1429) {
            class_1429 animal = (class_1429)entity;
            return !animal.method_6109();
        }
        return false;
    }

    @Override
    public void tick() {
        boolean isCreativeOrSpectator;
        boolean holdingShears;
        Map<Class<? extends class_1297>, Set<class_1792>> BREEDABLE_WHITELIST = Animals.BREEDABLE_WHITELIST;
        this.cleanupCooldownCache();
        class_638 world = BoxUtil.getWorld();
        class_746 player = BoxUtil.getPlayer();
        if (world == null || player == null) {
            return;
        }
        class_243 playerPos = BoxUtil.getPlayerPos();
        if (playerPos == null) {
            return;
        }
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        boolean bl = holdingShears = mainHand.method_31574(class_1802.field_8868) || offHand.method_31574(class_1802.field_8868);
        if (holdingShears) {
            double radius = AutoHarvestConfig.getInstance().getRadius();
            class_238 searchBox = BoxUtil.createSearchBox(playerPos, radius);
            List sheepList = world.method_8333((class_1297)player, searchBox, entity -> entity instanceof class_1472 && ((class_1472)entity).method_27072());
            sheepList.sort(Comparator.comparingDouble(e -> e.method_5858((class_1297)player)));
            Iterator iterator = sheepList.iterator();
            if (iterator.hasNext()) {
                class_1297 sheep = (class_1297)iterator.next();
                class_1268 hand = mainHand.method_31574(class_1802.field_8868) ? class_1268.field_5808 : class_1268.field_5810;
                InteractionHelper.interactEntity(player, sheep, hand);
                return;
            }
            return;
        }
        boolean enableRefill = AutoHarvestConfig.enableRefill();
        boolean bl2 = isCreativeOrSpectator = player.method_68878() || player.method_7325();
        if (!isCreativeOrSpectator && enableRefill) {
            class_1799 main = player.method_6047();
            class_1799 off = player.method_6079();
            if (!main.method_7960() && this.isBreedItem(main.method_7909()) && main.method_7947() < 64) {
                ItemRefillHelpermain.refillHands();
            }
            if (!off.method_7960() && this.isBreedItem(off.method_7909()) && off.method_7947() < 64) {
                ItemRefillHelperoff.refillOffHand();
            }
        }
        double radius = AutoHarvestConfig.getInstance().getRadius();
        class_238 searchBox = BoxUtil.createSearchBox(playerPos, radius);
        List entities = world.method_8333((class_1297)player, searchBox, entity -> {
            Set foods = (Set)BREEDABLE_WHITELIST.get(entity.getClass());
            return foods != null && this.canBreed((class_1297)entity) && !this.isOnCooldown((class_1297)entity);
        });
        entities.sort(Comparator.comparingDouble(e -> e.method_5858((class_1297)player)));
        for (class_1297 target : entities) {
            Set<class_1792> validFoods = BREEDABLE_WHITELIST.get(target.getClass());
            if (validFoods == null || validFoods.isEmpty() || !this.canBreed(target) || !this.tryFeedEntity(player, target, validFoods)) continue;
            this.markAsInteracted(target);
            return;
        }
    }

    private boolean isBreedItem(class_1792 item) {
        Map<Class<? extends class_1297>, Set<class_1792>> BREEDABLE_WHITELIST = Animals.BREEDABLE_WHITELIST;
        for (Set<class_1792> foods : BREEDABLE_WHITELIST.values()) {
            if (foods == null || !foods.contains(item)) continue;
            return true;
        }
        return false;
    }

    private boolean tryFeedEntity(class_746 player, class_1297 target, Set<class_1792> validFoods) {
        class_1799 main = player.method_6047();
        class_1799 off = player.method_6079();
        if (!main.method_7960() && validFoods.contains(main.method_7909())) {
            InteractionHelper.interactEntity(player, target, class_1268.field_5808);
            return true;
        }
        if (!off.method_7960() && validFoods.contains(off.method_7909())) {
            InteractionHelper.interactEntity(player, target, class_1268.field_5810);
            return true;
        }
        class_1792 bestFood = this.findBestFood(player, validFoods);
        if (bestFood == null) {
            return false;
        }
        for (int i = 0; i < 9; ++i) {
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || stack.method_7909() != bestFood) continue;
            player.method_31548().method_61496(i);
            InteractionHelper.interactEntity(player, target, class_1268.field_5808);
            return true;
        }
        return false;
    }

    private class_1792 findBestFood(class_746 player, Set<class_1792> validFoods) {
        if (validFoods.contains(player.method_6047().method_7909())) {
            return player.method_6047().method_7909();
        }
        if (validFoods.contains(player.method_6079().method_7909())) {
            return player.method_6079().method_7909();
        }
        int currentSlot = player.method_31548().method_67532();
        int bestSlot = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            int distance;
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !validFoods.contains(stack.method_7909()) || (distance = Math.abs(i - currentSlot)) >= minDistance) continue;
            minDistance = distance;
            bestSlot = i;
        }
        return bestSlot != -1 ? player.method_31548().method_5438(bestSlot).method_7909() : null;
    }

    @Override
    public String getName() {
        return class_2561.method_43471((String)"autoharvest.mode.feed").getString();
    }

    @Override
    public void onDisable() {
    }
}

