/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import java.util.Set;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.util.BoxUtil;
import kite.autoharvest.util.InteractionHelper;
import kite.autoharvest.util.ItemRefillHelpermain;
import kite.autoharvest.util.ItemRefillHelperoff;
import net.minecraft.class_1268;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2302;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2513;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class BonemealMode
implements AutoMode {
    private static final Set<class_2248> BONEMEAL_WHITELIST = Set.of(class_2246.field_10293, class_2246.field_10609, class_2246.field_10247, class_2246.field_10341, class_2246.field_46286, class_2246.field_46287, class_2246.field_16999);

    @Override
    public void tick() {
        class_638 world = BoxUtil.getWorld();
        class_746 player = BoxUtil.getPlayer();
        if (world == null || player == null) {
            return;
        }
        class_243 playerPos = BoxUtil.getPlayerPos();
        if (playerPos == null) {
            return;
        }
        if (!player.method_68878() && !player.method_7325() && AutoHarvestConfig.enableRefill()) {
            class_1799 main = player.method_6047();
            class_1799 off = player.method_6079();
            if (!main.method_7960() && main.method_7909() == class_1802.field_8324 && main.method_7947() < 64) {
                ItemRefillHelpermain.refillHands();
            }
            if (!off.method_7960() && off.method_7909() == class_1802.field_8324 && off.method_7947() < 64) {
                ItemRefillHelperoff.refillOffHand();
            }
        }
        double radius = AutoHarvestConfig.getInstance().getRadius();
        class_238 searchBox = BoxUtil.createSearchBox(playerPos, radius);
        int radiusInt = (int)Math.ceil(radius);
        for (class_2338 pos : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)playerPos), (int)radiusInt, (int)radiusInt, (int)radiusInt)) {
            class_2680 state;
            class_2248 block;
            if (!searchBox.method_1006(pos.method_46558()) || BoxUtil.isInSphere(pos, playerPos, radius) || !BONEMEAL_WHITELIST.contains(block = (state = world.method_8320(pos)).method_26204()) || !this.isNotFullyGrown(state, block) || !this.tryUseBonemeal(player, pos)) continue;
            return;
        }
    }

    private boolean isNotFullyGrown(class_2680 state, class_2248 block) {
        if (block instanceof class_2302) {
            if (block == class_2246.field_10341) {
                return (Integer)state.method_11654((class_2769)class_2741.field_12497) < 3;
            }
            return (Integer)state.method_11654((class_2769)class_2741.field_12550) < 7;
        }
        if (block instanceof class_2513) {
            return (Integer)state.method_11654((class_2769)class_2513.field_11584) < 7;
        }
        if (block == class_2246.field_16999) {
            return (Integer)state.method_11654((class_2769)class_2741.field_12497) < 3;
        }
        return false;
    }

    private boolean tryUseBonemeal(class_746 player, class_2338 pos) {
        class_1268 hand = null;
        if (player.method_6047().method_7909() == class_1802.field_8324) {
            hand = class_1268.field_5808;
        } else if (player.method_6079().method_7909() == class_1802.field_8324) {
            hand = class_1268.field_5810;
        }
        if (hand != null) {
            InteractionHelper.interactBlock(player, pos, hand, class_2350.field_11036);
            return true;
        }
        int currentSlot = player.method_31548().method_67532();
        int bestSlot = -1;
        int minDistance = Integer.MAX_VALUE;
        for (int i = 0; i < 9; ++i) {
            int dist;
            if (player.method_31548().method_5438(i).method_7909() != class_1802.field_8324 || (dist = Math.abs(i - currentSlot)) >= minDistance) continue;
            minDistance = dist;
            bestSlot = i;
        }
        if (bestSlot != -1) {
            player.method_31548().method_61496(bestSlot);
            InteractionHelper.interactBlock(player, pos, class_1268.field_5808, class_2350.field_11036);
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return class_2561.method_43471((String)"autoharvest.mode.bonemeal").getString();
    }

    @Override
    public void onDisable() {
    }
}

