/*
 * Decompiled with CFR 0.152.
 */
package kite.autoharvest.mode;

import java.util.Set;
import kite.autoharvest.config.AutoHarvestConfig;
import kite.autoharvest.mode.AutoMode;
import kite.autoharvest.util.BoxUtil;
import kite.autoharvest.util.InteractionHelper;
import kite.autoharvest.util.WaterProximityChecker;
import net.minecraft.class_1268;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class HoeMode
implements AutoMode {
    private static final Set<class_2248> HOEABLE_BLOCKS = Set.of(class_2246.field_10566, class_2246.field_10219, class_2246.field_10253, class_2246.field_28685);
    private static final Set<class_1792> HOES = Set.of(class_1802.field_8167, class_1802.field_8431, class_1802.field_8609, class_1802.field_8303, class_1802.field_8527, class_1802.field_22026);

    @Override
    public void tick() {
        class_638 world = BoxUtil.getWorld();
        class_746 player = BoxUtil.getPlayer();
        if (world == null || player == null) {
            return;
        }
        class_243 playerPos = BoxUtil.getPlayerPos();
        if (playerPos == null) {
            return;
        }
        double radius = AutoHarvestConfig.getInstance().getRadius();
        int radiusInt = (int)Math.ceil(radius);
        boolean hasValidBlock = false;
        for (class_2338 pos : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)playerPos), (int)radiusInt, (int)radiusInt, (int)radiusInt)) {
            if (BoxUtil.isInSphere(pos, playerPos, radius) || !HOEABLE_BLOCKS.contains(world.method_8320(pos).method_26204()) || !world.method_8320(pos.method_10084()).method_26215() || WaterProximityChecker.isWithinHydrationRange((class_1937)world, pos)) continue;
            hasValidBlock = true;
            break;
        }
        if (!hasValidBlock) {
            return;
        }
        class_1268 usedHand = this.getHoeInHand(player);
        if (usedHand == null) {
            int currentSlot = player.method_31548().method_67532();
            int bestSlot = -1;
            int minDistance = Integer.MAX_VALUE;
            for (int i = 0; i < 9; ++i) {
                int diff;
                int distance;
                class_1799 stack = player.method_31548().method_5438(i);
                if (stack.method_7960() || !HOES.contains(stack.method_7909()) || (distance = Math.min(diff = Math.abs(i - currentSlot), 9 - diff)) >= minDistance) continue;
                minDistance = distance;
                bestSlot = i;
            }
            if (bestSlot != -1 && AutoHarvestConfig.autoSwitchHotbar()) {
                player.method_31548().method_61496(bestSlot);
            }
            return;
        }
        for (class_2338 pos : class_2338.method_25996((class_2338)class_2338.method_49638((class_2374)playerPos), (int)radiusInt, (int)radiusInt, (int)radiusInt)) {
            if (BoxUtil.isInSphere(pos, playerPos, radius) || !HOEABLE_BLOCKS.contains(world.method_8320(pos).method_26204()) || !world.method_8320(pos.method_10084()).method_26215() || WaterProximityChecker.isWithinHydrationRange((class_1937)world, pos)) continue;
            InteractionHelper.interactBlock(player, pos, usedHand, class_2350.field_11036);
            return;
        }
    }

    private class_1268 getHoeInHand(class_746 player) {
        if (HOES.contains(player.method_6047().method_7909())) {
            return class_1268.field_5808;
        }
        if (HOES.contains(player.method_6079().method_7909())) {
            return class_1268.field_5810;
        }
        return null;
    }

    @Override
    public String getName() {
        return class_2561.method_43471((String)"autoharvest.mode.hoeing").getString();
    }

    @Override
    public void onDisable() {
    }
}

